/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;
import playerquests.Core;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;

public class ChatPrompt
extends GUIFunction {
    private String prompt;
    private String key;
    private String value = null;
    private boolean wasSetup = false;
    private boolean confirmedValue = false;
    private Listener chatListener;
    private Player player;

    public ChatPrompt(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    private void setup() {
        this.prompt = (String)this.params.get(0);
        this.key = (String)this.params.get(1);
        this.player = this.director.getPlayer();
        this.chatListener = new ChatPromptListener(this, this, Bukkit.getPlayer((UUID)this.player.getUniqueId()));
        try {
            PluginUtils.validateParams(this.params, String.class, String.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.player).type(ChatUtils.MessageType.ERROR).send();
        }
        this.director.getGUI().getResult().minimise();
        this.wasSetup = true;
        Bukkit.getPluginManager().registerEvents(this.chatListener, Core.getPlugin());
        this.execute();
    }

    @Override
    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        ChatUtils.clearChat((HumanEntity)this.player);
        if (this.value == null) {
            this.putPredefinedMessage(MessageType.REQUEST);
            return;
        }
        if (ChatUtils.isExitKeyword(this.value)) {
            this.putPredefinedMessage(MessageType.EXITED);
            this.confirmedValue = false;
            this.exit();
            return;
        }
        if (this.confirmedValue) {
            if (!this.key.equals("none")) {
                throw new IllegalArgumentException("KeyHandler removed.");
            }
            this.putPredefinedMessage(MessageType.CONFIRMED);
            this.exit();
            return;
        }
        if (this.value != null && !this.confirmedValue) {
            this.putPredefinedMessage(MessageType.CONFIRM);
        }
    }

    public void setResponse(String value) {
        if (this.value != null && ChatUtils.isConfirmKeyword(value).booleanValue()) {
            this.confirmedValue = true;
            return;
        }
        this.value = value;
    }

    public String getResponse() {
        if (this.confirmedValue) {
            return this.value;
        }
        return null;
    }

    private void putPredefinedMessage(MessageType type) {
        switch (type.ordinal()) {
            case 0: {
                ChatUtils.message(((TextComponent)((TextComponent)Component.empty().append(Component.text((String)this.prompt).decorate(TextDecoration.UNDERLINED))).appendNewline()).append(this.exitTextComponent())).player(this.player).send();
                break;
            }
            case 1: {
                ChatUtils.message(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)("Entered: " + this.value)).decorate(TextDecoration.ITALIC))).appendNewline()).append(Component.text((String)"enter again").color((TextColor)NamedTextColor.GRAY))).appendNewline()).append(this.confirmTextComponent())).appendNewline()).append(this.exitTextComponent())).player(this.player).send();
                break;
            }
            case 2: {
                ChatUtils.message(((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"exited"))).decorate(TextDecoration.ITALIC)).color((TextColor)NamedTextColor.RED)).player(this.player).send();
                break;
            }
            case 3: {
                ChatUtils.message(((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"confirmed"))).decorate(TextDecoration.ITALIC)).color((TextColor)NamedTextColor.DARK_GREEN)).player(this.player).send();
            }
        }
    }

    @NotNull
    private Component confirmTextComponent() {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"or type ").color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"confirm").color((TextColor)NamedTextColor.GRAY))).asComponent();
    }

    @NotNull
    private Component exitTextComponent() {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"or type ").color((TextColor)NamedTextColor.RED))).append(Component.text((String)"exit").color((TextColor)NamedTextColor.GRAY))).asComponent();
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this.chatListener);
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
            this.director.getGUI().getResult().display();
            this.finished();
            this.value = null;
            this.wasSetup = false;
            this.confirmedValue = false;
        });
    }

    private class ChatPromptListener
    implements Listener {
        private ChatPrompt parentClass;
        private Player player;

        public ChatPromptListener(ChatPrompt chatPrompt, ChatPrompt parent, Player player) {
            this.parentClass = parent;
            this.player = player;
        }

        @EventHandler
        private void onCommand(PlayerCommandPreprocessEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> this.parentClass.exit());
        }

        @EventHandler
        private void onChat(AsyncChatEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            String response = PlainTextComponentSerializer.plainText().serialize(event.message());
            event.setCancelled(true);
            this.parentClass.setResponse(response);
            this.parentClass.execute();
        }
    }

    private static enum MessageType {
        REQUEST,
        CONFIRM,
        EXITED,
        CONFIRMED;

    }
}

