/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import playerquests.Core;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.data.SelectMethod;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;
import playerquests.utility.serialisable.EntitySerialisable;

public class SelectEntity
extends GUIFunction {
    private Listener entityListener;
    private EntitySerialisable result;
    private Player player;
    private String prompt;
    private boolean wasSetup;
    private List<EntityType> deniedEntities;
    private List<SelectMethod> deniedMethods = List.of(SelectMethod.CHAT, SelectMethod.HIT, SelectMethod.SELECT);
    private boolean cancelled;

    public SelectEntity(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    private void setup() {
        try {
            PluginUtils.validateParams(this.params, String.class, List.class, List.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.player).type(ChatUtils.MessageType.ERROR).send();
        }
        this.prompt = (String)this.params.get(0);
        this.deniedEntities = this.castDeniedEntities(this.params.get(1));
        this.deniedMethods = this.castDeniedMethods(this.params.get(2));
        this.player = this.director.getPlayer();
        this.director.getGUI().getResult().minimise();
        this.entityListener = new SelectEntityListener(this, this, Bukkit.getPlayer((UUID)this.player.getUniqueId()));
        Bukkit.getPluginManager().registerEvents(this.entityListener, Core.getPlugin());
        this.wasSetup = true;
        this.execute();
    }

    private List<EntityType> castDeniedEntities(Object object) {
        List castedList = (List)object;
        return castedList.stream().filter(entityType -> entityType instanceof EntityType).map(entityType -> (EntityType)entityType).toList();
    }

    public List<EntityType> getDeniedEntities() {
        return this.deniedEntities;
    }

    private List<SelectMethod> castDeniedMethods(Object object) {
        List castedDenyList = (List)object;
        return Stream.concat(this.deniedMethods.stream(), castedDenyList.stream().filter(method -> method instanceof SelectMethod).map(method -> (SelectMethod)((Object)((Object)method)))).toList();
    }

    public List<SelectMethod> getDeniedMethods() {
        return this.deniedMethods;
    }

    @Override
    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        ChatUtils.clearChat((HumanEntity)this.player);
        if (this.cancelled) {
            ChatUtils.message(((TextComponent)Component.text((String)"exited").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)).player(this.player).send();
            this.exit();
            return;
        }
        if (this.result == null) {
            ChatUtils.message(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)this.prompt).decorate(TextDecoration.UNDERLINED))).appendNewline()).appendNewline()).append(Component.text((String)"or type ").color((TextColor)NamedTextColor.RED))).append(Component.text((String)"exit").color((TextColor)NamedTextColor.GRAY))).player(this.player).send();
            return;
        }
        ChatUtils.message(((TextComponent)Component.text((String)("Selected: " + this.result.toString())).decorate(TextDecoration.ITALIC)).color((TextColor)NamedTextColor.GRAY)).player(this.player).send();
        this.exit();
    }

    public void setResponse(EntitySerialisable entitySerialisable) {
        if (this.deniedEntities.contains(entitySerialisable.getData().getEntityType(entitySerialisable.getProperties()))) {
            ChatUtils.message("This entity is denied from being set as an NPC.").player(this.player).type(ChatUtils.MessageType.WARN).send();
            this.result = null;
            return;
        }
        this.result = entitySerialisable;
        this.execute();
    }

    public EntitySerialisable getResult() {
        return this.result;
    }

    private void exit() {
        HandlerList.unregisterAll((Listener)this.entityListener);
        this.finished();
    }

    private void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    private class SelectEntityListener
    implements Listener {
        private SelectEntity parentClass;
        private Player player;
        private List<SelectMethod> deniedMethods;

        public SelectEntityListener(SelectEntity selectEntity, SelectEntity parent, Player player) {
            this.parentClass = parent;
            this.player = player;
            this.deniedMethods = parent.getDeniedMethods();
        }

        @EventHandler
        private void onInteract(PlayerInteractEntityEvent event) {
            if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
                return;
            }
            if (this.player != event.getPlayer()) {
                return;
            }
            if (this.deniedMethods.contains((Object)SelectMethod.PAT)) {
                return;
            }
            Entity clickedEntity = event.getRightClicked();
            if (clickedEntity == null) {
                return;
            }
            event.setCancelled(true);
            EntitySerialisable entitySerialisable = EntitySerialisable.fromEntity(clickedEntity);
            if (entitySerialisable != null) {
                this.parentClass.setResponse(entitySerialisable);
            }
        }

        @EventHandler
        private void onCommand(PlayerCommandPreprocessEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                this.parentClass.setCancelled(true);
                this.parentClass.execute();
            });
        }

        @EventHandler
        private void onChat(AsyncChatEvent event) {
            if (this.player != event.getPlayer()) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                String message = PlainTextComponentSerializer.plainText().serialize(event.message());
                if (ChatUtils.isExitKeyword(message)) {
                    this.parentClass.setCancelled(true);
                    this.parentClass.execute();
                }
            });
        }
    }
}

