/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.function;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.PluginUtils;

public class UpdateScreen
extends GUIFunction {
    private Exception exception;
    GUIBuilder guiBuilder;
    private String screenNamePrevious;
    private String screenName;
    private Class<?> screenNameDynamic;
    private String error;
    private GUIDynamic dynamicGUI;

    public UpdateScreen(List<Object> params, ClientDirector director) {
        super(params, director);
    }

    @Override
    public void execute() {
        try {
            PluginUtils.validateParams(this.params, String.class);
        }
        catch (IllegalArgumentException e) {
            this.errored = true;
            ChatUtils.message(e.getMessage()).player(this.director.getPlayer()).type(ChatUtils.MessageType.ERROR).send();
        }
        this.director.getGUI().getResult().close();
        this.guiBuilder = new GUIBuilder(this.director, false);
        this.screenName = (String)this.params.get(0);
        List<String> screenNamesPrevious = this.director.getGUI().getPreviousScreens();
        this.screenNameDynamic = this.getDynamicClassFromName(this.screenName.toLowerCase());
        this.screenNamePrevious = this.director.getGUI().getScreenName();
        if (screenNamesPrevious.contains(this.screenName)) {
            screenNamesPrevious.remove(screenNamesPrevious.size() - 1);
        } else if (this.screenNamePrevious != null && !this.screenNamePrevious.equals(this.screenName)) {
            screenNamesPrevious.add(this.screenNamePrevious);
        }
        this.guiBuilder.setPreviousScreens(screenNamesPrevious);
        this.director.setCurrentInstance(this.guiBuilder);
        if (!screenNamesPrevious.isEmpty()) {
            this.screenNamePrevious = screenNamesPrevious.get(screenNamesPrevious.size() - 1);
        }
        if (this.screenNameDynamic != null) {
            this.fromDynamic();
        } else {
            this.error = "Could not load dynamic GUI (static GUI's are deprecated)";
        }
        if (this.error != null) {
            ChatUtils.message(this.error).player(this.director.getPlayer()).type(ChatUtils.MessageType.ERROR).send();
            ChatUtils.message(this.exception.toString()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            return;
        }
        this.finished();
    }

    private void fromDynamic() {
        try {
            GUIDynamic guiDynamic = (GUIDynamic)this.screenNameDynamic.getDeclaredConstructor(ClientDirector.class, String.class).newInstance(this.director, this.screenNamePrevious);
            guiDynamic.execute();
            this.dynamicGUI = guiDynamic;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.exception = e;
            this.error = "The " + this.screenName + " screen could not be initialised.";
        }
    }

    private Class<?> getDynamicClassFromName(String name) {
        try {
            return Class.forName("playerquests.builder.gui.dynamic.Dynamic" + name);
        }
        catch (ClassNotFoundException e) {
            this.error = "The " + this.screenName + " dynamic screen requested in the " + this.screenNamePrevious + " screen, is not valid.";
            this.exception = e;
            return null;
        }
    }

    public GUIDynamic getDynamicGUI() {
        return this.dynamicGUI;
    }

    public String getPreviousScreen() {
        return this.screenNamePrevious;
    }
}

