/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.singleton.QuestRegistry;

public class QuestBuilder {
    private boolean isValid = true;
    private boolean universal = false;
    private ClientDirector director;
    @JsonProperty(value="title")
    private String title = "";
    @JsonIgnore
    private Map<String, QuestNPC> questNPCs = new HashMap<String, QuestNPC>();
    @JsonIgnore
    private Map<String, QuestStage> questPlan = new HashMap<String, QuestStage>();
    private UUID originalCreator;
    @JsonProperty(value="startpoints")
    private List<StagePath> startPoints = new ArrayList<StagePath>();

    public QuestBuilder(ClientDirector director) {
        this.director = director;
        director.setCurrentInstance(this);
        this.build();
    }

    public QuestBuilder(ClientDirector director, Quest product) {
        try {
            this.director = director;
            this.title = product.getTitle();
            this.questPlan = product.getStages();
            product.getNPCs().forEach((id, npc) -> {
                npc.setID((String)id);
                this.questNPCs.put((String)id, (QuestNPC)npc);
            });
            if (product.getCreator() == null) {
                this.universal = true;
                director.setCurrentInstance(this.build());
            } else {
                if (product.getCreator() != director.getPlayer().getUniqueId()) {
                    this.originalCreator = product.getCreator();
                }
                director.setCurrentInstance(this);
            }
            this.startPoints = product.getStartPoints();
            this.build();
        }
        catch (Exception e) {
            this.isValid = false;
        }
    }

    @JsonIgnore
    public UUID getOriginalCreator() {
        return this.originalCreator;
    }

    public QuestBuilder setDirector(ClientDirector director) {
        this.director = director;
        if (director != null) {
            director.setCurrentInstance(this);
            this.universal = false;
            this.build();
        }
        return this;
    }

    public QuestBuilder setTitle(String title) {
        if (title == null || title.isBlank()) {
            this.title = "My Quest";
            return this;
        }
        if (title.contains("_")) {
            ChatUtils.message("Quest label '" + this.title + "' not allowed underscores.").player(this.director.getPlayer()).type(ChatUtils.MessageType.WARN).send();
            return this;
        }
        this.title = title;
        this.build();
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    @JsonIgnore
    public List<QuestStage> getStages() {
        return this.questPlan.values().stream().sorted(Comparator.comparingInt(stage -> {
            String[] parts = stage.getID().split("_");
            return Integer.parseInt(parts[1]);
        })).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonProperty(value="stages")
    public Map<String, QuestStage> getQuestPlan() {
        return this.questPlan;
    }

    @JsonProperty(value="npcs")
    public Map<String, QuestNPC> getQuestNPCs() {
        return this.questNPCs.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("npc_-1")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @JsonProperty(value="npcs")
    public Map<String, QuestNPC> getQuestNPCs(boolean all) {
        if (!all) {
            return this.getQuestNPCs();
        }
        return this.questNPCs;
    }

    @JsonIgnore
    public Boolean addNPC(QuestNPC npc) {
        QuestClient quester = QuestRegistry.getInstance().getQuester(this.getDirector().getPlayer());
        if (this.questNPCs.containsKey(npc.getID())) {
            this.questNPCs.remove(npc.getID());
            npc.refund(quester);
        }
        npc.setQuest(this.build());
        if (!npc.isValid()) {
            npc.setID("npc_-1");
            npc.setQuest(null);
            return false;
        }
        npc.setID(this.nextNPCID());
        this.questNPCs.put(npc.getID(), npc);
        npc.penalise(quester);
        return true;
    }

    public void removeNPC(QuestNPC npc) {
        if (this.questNPCs.remove(npc.getID()) == null) {
            return;
        }
        QuestRegistry.getInstance().getAllQuesters().forEach(quester -> npc.despawn((QuestClient)quester));
    }

    @JsonIgnore
    public String nextNPCID() {
        Integer npcID = IntStream.iterate(0, i -> i + 1).filter(i -> !this.questNPCs.keySet().contains("npc_" + i)).findFirst().orElse(-1);
        return "npc_" + npcID;
    }

    @JsonIgnore
    public ClientDirector getDirector() {
        return this.director;
    }

    @JsonIgnore
    public Quest build() {
        Quest product = new Quest(this.title, this.questNPCs, this.questPlan, this.universal ? null : this.director.getPlayer().getUniqueId(), this.getID(), this.startPoints);
        if (!this.universal) {
            this.director.setCurrentInstance(product);
        }
        return product;
    }

    public QuestStage addStage(QuestStage questStage) {
        this.getQuestPlan().put(questStage.getID(), questStage);
        this.build();
        return questStage;
    }

    public boolean removeStage(QuestStage questStage, boolean dryRun) {
        Boolean canRemove = true;
        if (dryRun) {
            return canRemove;
        }
        this.questPlan.remove(questStage.getID());
        return canRemove;
    }

    public boolean removeStage(QuestStage questStage) {
        return this.removeStage(questStage, false);
    }

    @JsonIgnore
    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        return this.build().isValid();
    }

    public String getID() {
        String creator = this.getDirector().getPlayer().getUniqueId().toString();
        return String.format("%s%s", this.title, creator != null ? "_" + creator : "");
    }

    public void setStartPoints(List<StagePath> startPoints) {
        if (startPoints == null) {
            this.startPoints = List.of();
            return;
        }
        this.startPoints = startPoints;
    }
}

