/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.data.ActionTweaks;
import playerquests.builder.quest.action.listener.SpeakListener;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.action.option.DialogueOption;
import playerquests.builder.quest.action.option.NPCOption;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.QuestNPC;

public class SpeakAction
extends QuestAction<SpeakAction, SpeakListener> {
    QuestNPC npc;

    @Override
    public String getName() {
        return "Speak";
    }

    @Override
    protected void prepare(QuesterData questerData) {
        this.npc = this.spawnNPC(questerData);
    }

    @Override
    protected boolean isCompleted(QuesterData questerData) {
        return true;
    }

    @Override
    protected void success(QuesterData questerData) {
        Player player = questerData.getQuester().getPlayer();
        this.getData().getOption(DialogueOption.class).ifPresent(dialogue -> player.sendPlainMessage(String.format("<%s> %s", this.npc.getName(), dialogue.getText().getFirst())));
        this.despawnNPC(questerData);
    }

    @Override
    protected void failure(QuesterData questerData) {
    }

    @Override
    protected SpeakListener startListener(QuesterData questerData) {
        return new SpeakListener(this, questerData);
    }

    @Override
    public GUISlot createSlot(GUIBuilder gui, Integer slot) {
        return new GUISlot(gui, slot).setLabel(this.getName()).setDescription(List.of("Makes an NPC speak.")).setItem(Material.OAK_SIGN);
    }

    @Override
    public List<Class<? extends ActionOption>> getOptions() {
        return List.of(NPCOption.class, DialogueOption.class);
    }

    @Override
    public List<Class<? extends ActionCondition>> getConditionBlocklist() {
        return List.of();
    }

    @Override
    protected Class<?> getListenerType() {
        return SpeakListener.class;
    }

    @Override
    public LocationData getLocation() {
        return new LocationData(this.npc.getLocation());
    }

    @Override
    public List<ActionTweaks> getTweaks() {
        return List.of();
    }
}

