/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.data.ActionTweaks;
import playerquests.builder.quest.action.listener.WalkActionListener;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.action.option.LocationOption;
import playerquests.builder.quest.action.option.NPCOption;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.product.Quest;

public class WalkAction
extends QuestAction<WalkAction, WalkActionListener> {
    @JsonIgnore
    private LocationData locationData;
    @JsonIgnore
    private QuestNPC npc;

    @Override
    public List<Class<? extends ActionOption>> getOptions() {
        return List.of(LocationOption.class, NPCOption.class);
    }

    @Override
    public List<Class<? extends ActionCondition>> getConditionBlocklist() {
        return List.of();
    }

    @Override
    public List<ActionTweaks> getTweaks() {
        return List.of(ActionTweaks.NO_FX);
    }

    @Override
    public String getName() {
        return "Walk";
    }

    @Override
    protected void prepare(QuesterData questerData) {
        Optional<NPCOption> npcOption = this.getData().getOption(NPCOption.class);
        Optional<LocationOption> locationOption = this.getData().getOption(LocationOption.class);
        Quest quest = this.getStage().getQuest();
        if (npcOption.isEmpty()) {
            throw new IllegalStateException("NPCOption must be set for this action in " + quest.getID());
        }
        if (locationOption.isEmpty() || locationOption.get().getLocation() == null) {
            throw new IllegalStateException("LocationOption with valid LocationData must be set for this action in " + quest.getID());
        }
        this.locationData = locationOption.get().getLocation();
        this.npc = npcOption.get().getNPC(quest);
        this.npc.getAssigned().walkTo(this.locationData, questerData, this);
    }

    @Override
    protected boolean isCompleted(QuesterData questerData) {
        return this.npc.getAssigned().isCurrentlyAt(this.locationData, questerData, this);
    }

    @Override
    protected Class<?> getListenerType() {
        return WalkActionListener.class;
    }

    @Override
    protected void success(QuesterData questerData) {
    }

    @Override
    protected void failure(QuesterData questerData) {
    }

    @Override
    protected WalkActionListener startListener(QuesterData questerData) {
        return new WalkActionListener(this, questerData);
    }

    @Override
    public GUISlot createSlot(GUIBuilder gui, Integer slot) {
        return new GUISlot(gui, slot).setLabel(this.getName()).setDescription(List.of("Makes an NPC walk to ", "a location.")).setItem(Material.CARROT_ON_A_STICK);
    }

    @Override
    public LocationData getLocation() {
        return this.getData().getOption(LocationOption.class).map(LocationOption::getLocation).orElse(null);
    }
}

