/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.condition;

import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.client.ClientDirector;

public class SleepCondition
extends ActionCondition {
    private int minimumSleeps = 0;
    private int maximumSleeps = 0;

    public SleepCondition() {
    }

    public SleepCondition(ActionData actionData) {
        this.actionData = actionData;
    }

    @Override
    public boolean isMet(QuesterData questerData) {
        QuestAction<?, ?> action = this.getActionData().getAction();
        int sleepCount = questerData.getSleepCount(action);
        int upperSleepCountBound = this.getMaximumSleeps();
        boolean maximumSatisfied = upperSleepCountBound == 0 || sleepCount <= upperSleepCountBound;
        return sleepCount > this.getMinimumSleeps() && maximumSatisfied;
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        return new GUISlot(gui, slot).setLabel(this.getName()).setDescription(this.getDescription()).setItem(Material.RED_BED);
    }

    @Override
    public String getName() {
        return "Sleep";
    }

    @Override
    public void createEditorGUI(GUIDynamic screen, GUIBuilder gui, ClientDirector director) {
        String minimumSleepsLabel = "Set minimum sleeps";
        String maximumSleepsLabel = "Set maximum sleeps";
        if (this.getMinimumSleeps() != 0) {
            minimumSleepsLabel = String.format("%s (%s)", minimumSleepsLabel, this.getMinimumSleeps());
        }
        if (this.getMaximumSleeps() != 0) {
            maximumSleepsLabel = String.format("%s (%s)", maximumSleepsLabel, this.getMaximumSleeps());
        }
        new GUISlot(gui, 3).setLabel(minimumSleepsLabel).setItem(Material.ICE).onClick(() -> new ChatPrompt(List.of("Set the minimum sleeps, 0 means no minimum", "none"), director).onFinish(f -> {
            ChatPrompt chatPrompt = (ChatPrompt)f;
            this.setMinimumSleeps(Integer.parseInt(chatPrompt.getResponse()));
            screen.refresh();
        }).execute());
        new GUISlot(gui, 4).setLabel(maximumSleepsLabel).setItem(Material.WATER_BUCKET).onClick(() -> new ChatPrompt(List.of("Set the maximum sleeps, 0 means no maximum", "none"), director).onFinish(f -> {
            ChatPrompt chatPrompt = (ChatPrompt)f;
            this.setMaximumSleeps(Integer.parseInt(chatPrompt.getResponse()));
            screen.refresh();
        }).execute());
    }

    private void setMaximumSleeps(int sleeps) {
        this.maximumSleeps = sleeps;
    }

    private void setMinimumSleeps(int sleeps) {
        this.minimumSleeps = sleeps;
    }

    public int getMaximumSleeps() {
        return this.maximumSleeps;
    }

    public int getMinimumSleeps() {
        return this.minimumSleeps;
    }

    @Override
    public List<String> getDetails() {
        return List.of(String.format("Requires %d%s", this.getMinimumSleeps(), this.getMaximumSleeps() == 0 ? " Sleeps" : "-" + this.getMaximumSleeps() + " Sleeps"));
    }

    @Override
    public List<String> getDescription() {
        return List.of("Waits until the ", "player has slept.");
    }

    @Override
    public void startListener(QuesterData questerData) {
        new SleepConditionListener(this, this, questerData);
    }

    @Override
    public void cleanUp(QuesterData questerData, ActionData actionData) {
        QuestAction<?, ?> action = actionData.getAction();
        questerData.removeSleepCount(action);
    }

    class SleepConditionListener
    extends ActionCondition.ActionConditionListener<SleepCondition> {
        protected SleepConditionListener(SleepCondition this$0, SleepCondition actionCondition, QuesterData questerData) {
            super((ActionCondition)this$0, (ActionCondition)actionCondition, questerData);
        }

        @EventHandler
        private void onSleep(PlayerDeepSleepEvent event) {
            if (!event.getPlayer().getUniqueId().equals(this.questerData.getQuester().getPlayer().getUniqueId())) {
                return;
            }
            QuestAction<?, ?> action = ((SleepCondition)this.actionCondition).getActionData().getAction();
            int sleepCount = this.questerData.getSleepCount(action);
            int upperSleepCountBound = ((SleepCondition)this.actionCondition).getMaximumSleeps();
            this.questerData.setSleepCount(action, sleepCount + 1);
            if (((SleepCondition)this.actionCondition).isMet(this.questerData)) {
                this.trigger(true);
            }
            if (sleepCount >= upperSleepCountBound || upperSleepCountBound == 0) {
                this.close();
            }
        }
    }
}

