/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.listener;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import playerquests.Core;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.QuesterData;

public abstract class ActionListener<A extends QuestAction<A, ?>>
implements Listener {
    protected final A action;
    protected final QuesterData questerData;

    protected ActionListener(A action, QuesterData questerData) {
        this.action = action;
        this.questerData = questerData;
        questerData.addListener((QuestAction<?, ?>)action, this);
        Bukkit.getPluginManager().registerEvents((Listener)this, Core.getPlugin());
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    protected boolean passedPlayerCheck(Player player) {
        return player.equals((Object)this.questerData.getQuester().getPlayer());
    }

    protected void autoTrigger(QuesterData questerData) {
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> ((QuestAction)this.action).check(questerData), 20L);
    }
}

