/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.listener;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.quest.action.CraftAction;
import playerquests.builder.quest.action.listener.ActionListener;
import playerquests.builder.quest.action.option.ItemsOption;
import playerquests.builder.quest.data.QuesterData;
import playerquests.utility.serialisable.ItemSerialisable;

public class CraftListener
extends ActionListener<CraftAction> {
    private Map<ItemSerialisable, Integer> progress;

    public CraftListener(CraftAction action, QuesterData questerData) {
        super(action, questerData);
        this.progress = new HashMap<ItemSerialisable, Integer>(action.getData().getOption(ItemsOption.class).get().getItems());
    }

    @EventHandler
    public void onPlayerCrafted(CraftItemEvent event) {
        Player questPlayer = this.questerData.getQuester().getPlayer();
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof Player)) {
            return;
        }
        Player craftPlayer = (Player)inventoryHolder;
        if (craftPlayer.getUniqueId() != questPlayer.getUniqueId()) {
            return;
        }
        ItemStack itemStack = event.getRecipe().getResult();
        ItemSerialisable item = ItemSerialisable.fromItemStack(event.getRecipe().getResult());
        Integer quantityRemaining = this.progress.get(item);
        if (quantityRemaining == null) {
            return;
        }
        Integer updatedQuantityRemaining = quantityRemaining - itemStack.getAmount();
        if (updatedQuantityRemaining <= 0) {
            this.progress.remove(item);
            craftPlayer.sendMessage("<Finished crafting " + item.getName() + ">");
        } else {
            this.progress.put(item, updatedQuantityRemaining);
            craftPlayer.sendMessage("<Craft " + updatedQuantityRemaining + " more " + item.getName() + ">");
        }
        if (this.progress.isEmpty()) {
            ((CraftAction)this.action).check(this.questerData);
        }
    }
}

