/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicitemslist;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.data.ActionData;
import playerquests.client.ClientDirector;
import playerquests.utility.serialisable.ItemSerialisable;

public class ItemsOption
extends ActionOption {
    @JsonProperty(value="items")
    private Map<ItemSerialisable, Integer> items = new HashMap<ItemSerialisable, Integer>();

    public ItemsOption() {
    }

    public ItemsOption(ActionData actionData) {
        super(actionData);
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        List<String> itemStrings = this.items.entrySet().stream().map(entry -> String.format("%s (%d)", ((ItemSerialisable)entry.getKey()).getName(), entry.getValue())).toList();
        return new GUISlot(gui, slot).setLabel(this.getItems().isEmpty() ? "Set items" : "Change the items").setDescription(itemStrings).setItem(Material.CHEST).onClick(() -> {
            director.setCurrentInstance(new ArrayList<ItemStack>(this.toList(this.getItems())));
            new UpdateScreen(List.of("itemslist"), director).onFinish(f -> {
                UpdateScreen updateScreen = (UpdateScreen)f;
                Dynamicitemslist itemsList = (Dynamicitemslist)updateScreen.getDynamicGUI();
                itemsList.onFinish(portableDynamicGUI -> {
                    Dynamicitemslist portableItemsList = (Dynamicitemslist)portableDynamicGUI;
                    this.setItems(this.toMap(portableItemsList.getItems()));
                    this.actionData.setOption(this);
                    screen.refresh();
                    director.removeCurrentInstance(ArrayList.class);
                });
            }).execute();
        });
    }

    public void setItems(Map<ItemSerialisable, Integer> items) {
        this.items = items;
    }

    public Map<ItemSerialisable, Integer> getItems() {
        return this.items;
    }

    public Map<ItemSerialisable, Integer> addItems(ItemSerialisable material, int amount) {
        this.items.put(material, amount);
        return this.items;
    }

    public Map<ItemSerialisable, Integer> deleteItems(ItemSerialisable material) {
        this.items.remove(material);
        return this.items;
    }

    private Map<ItemSerialisable, Integer> toMap(List<ItemStack> items) {
        return items.stream().collect(Collectors.toMap(ItemSerialisable::fromItemStack, ItemStack::getAmount));
    }

    private List<ItemStack> toList(Map<ItemSerialisable, Integer> items) {
        return items.entrySet().stream().map(entry -> {
            ItemStack itemStack = ((ItemSerialisable)entry.getKey()).toItemStack();
            itemStack.setAmount(((Integer)entry.getValue()).intValue());
            return itemStack;
        }).toList();
    }

    @Override
    public Optional<String> isValid() {
        if (this.getItems().isEmpty()) {
            return Optional.of("No items are set, try choosing some items in the options menu.");
        }
        return Optional.empty();
    }
}

