/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.option;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.SelectLocation;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.LocationData;
import playerquests.client.ClientDirector;

public class LocationOption
extends ActionOption {
    protected LocationData location = null;

    public LocationOption() {
    }

    public LocationOption(ActionData actionData) {
        super(actionData);
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        List<String> locationStrings = Optional.ofNullable(this.getLocation()).map(l -> List.of("X: " + l.getX(), "Y: " + l.getY(), "Z: " + l.getZ())).orElse(List.of("Place at the location ", "you want to set"));
        return new GUISlot(gui, slot).setLabel(this.getLocation() == null ? "Set location" : "Change the location").setDescription(locationStrings).setItem(Material.CHEST).onClick(() -> new SelectLocation(Arrays.asList("Place the block at the location"), director).onFinish(guiFunction -> {
            SelectLocation selectLocation = (SelectLocation)guiFunction;
            this.setLocation(selectLocation.getResult());
            this.actionData.setOption(this);
            screen.refresh();
        }).execute());
    }

    @Override
    public Optional<String> isValid() {
        if (this.getLocation() == null) {
            return Optional.of("No location was set, try setting the location in the options menu.");
        }
        return Optional.empty();
    }

    public LocationData getLocation() {
        return this.location;
    }

    private void setLocation(LocationData location) {
        this.location = location;
    }
}

