/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.npc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicnpctypes;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.SelectLocation;
import playerquests.builder.gui.function.SelectMaterial;
import playerquests.builder.gui.function.data.SelectMethod;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.NPCType;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.utility.ChatUtils;
import playerquests.utility.MaterialUtils;
import playerquests.utility.serialisable.ItemSerialisable;

public class BlockNPC
extends NPCType {
    @JsonIgnore
    private BlockData blockData;

    public BlockNPC() {
    }

    public BlockNPC(String value, QuestNPC npc) {
        super(value, npc);
        this.blockData = this.getBlock();
        this.type = "Block";
    }

    public BlockNPC(BlockData block, QuestNPC npc) {
        super(ItemSerialisable.fromItemStack(new ItemStack(block.getMaterial())).getAsString(), npc);
        this.blockData = block.clone();
        this.type = "Block";
    }

    @JsonIgnore
    public BlockData getBlock() {
        if (this.value.startsWith("minecraft:")) {
            return this.getBlockLegacy();
        }
        if (this.blockData == null) {
            ItemSerialisable itemSerialisable = new ItemSerialisable(this.value);
            Block block = itemSerialisable.getData().spawn(itemSerialisable.getProperties(), this.npc.getLocation().toBukkitLocation());
            BlockData blockData = block.getBlockData().clone();
            block.setType(Material.AIR);
            this.blockData = blockData;
        }
        return this.blockData;
    }

    @JsonIgnore
    public BlockData getBlockLegacy() {
        BlockData finalBlockData = Material.RED_WOOL.createBlockData();
        try {
            finalBlockData = Bukkit.getServer().createBlockData(this.value);
        }
        catch (IllegalArgumentException e) {
            ChatUtils.message("malformed block data in a quest.").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            Material fallbackMaterial = Material.getMaterial((String)this.value);
            if (fallbackMaterial != null) {
                finalBlockData = fallbackMaterial.createBlockData();
            }
            this.value = finalBlockData.getAsString(true);
        }
        return finalBlockData;
    }

    @JsonProperty(value="value")
    public String getBlockString() {
        return this.value;
    }

    @Override
    public GUISlot createTypeSlot(GUIDynamic screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        return new GUISlot(gui, slot).setLabel("A Block" + (npc.getAssigned() instanceof BlockNPC ? " (Selected)" : "")).setItem(Material.GRASS_BLOCK).onClick(() -> new SelectMaterial(Arrays.asList("Select a block from your inventory", Arrays.asList("BARRIER", "DRAGON_EGG"), Arrays.asList(SelectMethod.HIT, SelectMethod.CHAT), true), director).onFinish(f -> {
            SelectMaterial function = (SelectMaterial)f;
            ItemStack item = function.getResult();
            if (item != null) {
                BlockNPC blockNPC = new BlockNPC(item.getType().createBlockData(), npc);
                npc.assign(blockNPC);
            }
            gui.getResult().display();
            screen.refresh();
        }).execute());
    }

    @Override
    public GUISlot createPlaceSlot(Dynamicnpctypes screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        LocationData locationData = npc.getLocation();
        return new GUISlot(gui, slot).setLabel(String.format("%s", npc.getLocation() == null ? "Place NPC (" + npc.getAssigned().getType() + ")" : "Relocate NPC (" + npc.getAssigned().getType() + ")")).setDescription(locationData != null ? List.of(String.format("X: %.0f", locationData.getX()), String.format("Y: %.0f", locationData.getY()), String.format("Z: %.0f", locationData.getZ())) : List.of()).setItem(npc.isAssigned() ? npc.getBlock().getMaterial() : Material.BARRIER).onClick(() -> {
            Player player = director.getPlayer();
            PlayerInventory playerInventory = player.getInventory();
            ItemStack[] playerInventoryContents = playerInventory.getContents();
            playerInventory.clear();
            playerInventory.setItemInMainHand(MaterialUtils.toItemStack(npc.getBlock().getMaterial().toString()));
            new SelectLocation(Arrays.asList("Place the NPC Block"), director).onFinish(f -> {
                SelectLocation function = (SelectLocation)f;
                LocationData location = function.getResult();
                BlockData block = function.getBlockData();
                if (location != null) {
                    npc.setLocation(location);
                }
                if (block != null) {
                    npc.assign(new BlockNPC(block, npc));
                }
                playerInventory.setContents(playerInventoryContents);
                screen.refresh();
            }).execute();
        });
    }

    @Override
    public void refund(QuestClient quester) {
        Player player = quester.getPlayer();
        ItemStack item = new ItemStack(this.getBlock().getMaterial());
        PlayerInventory playerInventory = player.getInventory();
        if (playerInventory.firstEmpty() != -1) {
            playerInventory.addItem(new ItemStack[]{item});
            return;
        }
        Location playerLocation = player.getLocation();
        playerLocation.getWorld().dropItem(playerLocation, item);
    }

    @Override
    public void penalise(QuestClient quester) {
        Player player = quester.getPlayer();
        ItemStack item = new ItemStack(this.getBlock().getMaterial(), 1);
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.removeItem(new ItemStack[]{item});
    }

    @Override
    public void unregister(QuestAction<?, ?> action, QuestClient quester) {
        quester.getData().removeBlockNPC(action, this.getNPC());
    }

    @Override
    public void despawn(QuestAction<?, ?> action, QuestClient quester) {
        Player player = quester.getPlayer();
        Block block = quester.getData().getBlockNPC(action, this.getNPC());
        if (block == null) {
            return;
        }
        player.sendBlockChange(block.getLocation(), Material.AIR.createBlockData());
    }

    @Override
    public void register(QuestAction<?, ?> action, QuestClient quester, Object value) {
        quester.getData().addBlockNPC(action, this.getNPC(), (Block)value);
    }

    @Override
    public Object spawn(QuestAction<?, ?> action, QuestClient quester) {
        Player player = quester.getPlayer();
        Location location = this.getNPC().getLocation().toBukkitLocation();
        BlockData blockData = this.getBlock();
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> player.sendBlockChange(location, blockData), 1L);
        return location.getBlock();
    }

    @Override
    public boolean isCurrentlyAt(LocationData locationData, QuesterData questerData, QuestAction<?, ?> action) {
        Block block = questerData.getBlockNPC(action, this.npc);
        if (block == null) {
            return false;
        }
        Location blockLocation = block.getLocation();
        blockLocation.setWorld(Bukkit.getWorld((String)this.getNPC().getLocation().getWorld()));
        return locationData.toBukkitLocation().distanceSquared(blockLocation) <= 1.0;
    }

    @Override
    public void walkTo(LocationData locationData, final QuesterData questerData, final WalkAction action) {
        final QuestNPC walkingNpc = this.npc;
        walkingNpc.spawn(action, questerData.getQuester());
        final Player player = questerData.getQuester().getPlayer();
        final Location startLoc = this.getNPC().getLocation().toBukkitLocation();
        final Location endLoc = locationData.toBukkitLocation();
        Material movingBlockType = this.getBlock().getMaterial();
        final BlockData blockData = movingBlockType.createBlockData();
        long delayBetweenSteps = 7L;
        Vector direction = endLoc.toVector().subtract(startLoc.toVector());
        double distance = direction.length();
        final int totalSteps = (int)distance;
        final Vector stepVector = direction.normalize().multiply(distance / (double)totalSteps);
        new BukkitRunnable(this){
            private int currentStep = 0;

            public void run() {
                if (!questerData.getQuester().getTrackedActions().contains(action)) {
                    this.cancel();
                }
                if (this.currentStep > 0) {
                    Location prevLoc = startLoc.clone().add(stepVector.clone().multiply(this.currentStep - 1));
                    player.sendBlockChange(prevLoc, Material.AIR.createBlockData());
                }
                if (this.currentStep >= totalSteps) {
                    player.sendBlockChange(endLoc, blockData);
                    new BukkitRunnable(){

                        public void run() {
                            questerData.addBlockNPC(action, walkingNpc, endLoc.getBlock());
                            action.check(questerData);
                        }
                    }.runTaskLater(Core.getPlugin(), 20L);
                    this.cancel();
                    return;
                }
                Location currentLocation = startLoc.clone().add(stepVector.clone().multiply(this.currentStep));
                player.sendBlockChange(currentLocation, blockData);
                ++this.currentStep;
            }
        }.runTaskTimer(Core.getPlugin(), 0L, delayBetweenSteps);
    }
}

