/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.npc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.LookClose;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicnpctypes;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.SelectEntity;
import playerquests.builder.gui.function.SelectLocation;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.NPCType;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.EntitySerialisable;
import playerquests.utility.serialisable.data.EntityData;
import playerquests.utility.singleton.PlayerQuests;

public class EntityNPC
extends NPCType {
    public EntityNPC() {
    }

    public EntityNPC(String value, QuestNPC npc) {
        super(value, npc);
        this.type = "Entity";
    }

    public EntityNPC(EntitySerialisable entitySerialisable, QuestNPC npc) {
        this(entitySerialisable.toString(), npc);
    }

    @Override
    public GUISlot createTypeSlot(GUIDynamic screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        EntityNPC entityNPC;
        boolean hasCitizens2 = PlayerQuests.getInstance().hasCitizens2();
        NPCType nPCType = npc.getAssigned();
        boolean isNonPlayerEntity = nPCType instanceof EntityNPC && (entityNPC = (EntityNPC)nPCType).getEntity().getData() != EntityData.PLAYER;
        return new GUISlot(gui, slot).setLabel("An Entity" + (isNonPlayerEntity ? " (Selected)" : "")).setDescription(hasCitizens2 ? Component.empty().append(Component.text((String)"Utilises Citizens2").color((TextColor)NamedTextColor.DARK_GRAY)) : ((TextComponent)Component.empty().append((Component)Component.text((String)"Entity NPCs require"))).append((Component)Component.text((String)"the Citizens2 plugin"))).setItem(hasCitizens2 ? Material.EGG : Material.BARRIER).onClick(() -> {
            if (!hasCitizens2) {
                return;
            }
            new SelectEntity(Arrays.asList("Select an entity", List.of(), List.of()), director).onFinish(f -> {
                SelectEntity selectEntity = (SelectEntity)f;
                EntitySerialisable entitySerialisable = selectEntity.getResult();
                if (entitySerialisable != null) {
                    EntityNPC entityNPC = new EntityNPC(entitySerialisable, npc);
                    npc.assign(entityNPC);
                }
                gui.getResult().display();
                screen.refresh();
            }).execute();
        });
    }

    @JsonIgnore
    public EntitySerialisable getEntity() {
        EntitySerialisable entityData;
        try {
            entityData = new EntitySerialisable(this.value);
        }
        catch (IllegalArgumentException e) {
            ChatUtils.message("malformed entity data in a quest. " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            entityData = new EntitySerialisable("entity:VILLAGER");
            this.value = entityData.toString();
        }
        return entityData;
    }

    @Override
    public GUISlot createPlaceSlot(Dynamicnpctypes screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        LocationData locationData = npc.getLocation();
        return new GUISlot(gui, slot).setLabel(String.format("%s", npc.getLocation() == null ? "Place NPC (" + npc.getAssigned().getType() + ")" : "Relocate NPC (" + npc.getAssigned().getType() + ")")).setDescription(locationData != null ? List.of(String.format("X: %.0f", locationData.getX()), String.format("Y: %.0f", locationData.getY()), String.format("Z: %.0f", locationData.getZ())) : List.of()).setItem(Material.GREEN_STAINED_GLASS).onClick(() -> {
            Player player = director.getPlayer();
            PlayerInventory playerInventory = player.getInventory();
            ItemStack[] playerInventoryContents = playerInventory.getContents();
            playerInventory.clear();
            playerInventory.setItemInMainHand(new ItemStack(Material.GREEN_STAINED_GLASS));
            new SelectLocation(Arrays.asList("Place the NPC Block"), director).onFinish(f -> {
                SelectLocation function = (SelectLocation)f;
                LocationData location = function.getResult();
                if (location != null) {
                    npc.setLocation(location);
                }
                playerInventory.setContents(playerInventoryContents);
                screen.refresh();
            }).execute();
        });
    }

    @Override
    protected void unregister(QuestAction<?, ?> action, QuestClient quester) {
        quester.getData().removeEntityNPC(action, this.getNPC());
    }

    @Override
    protected void despawn(QuestAction<?, ?> action, QuestClient quester) {
        NPC citizen = quester.getData().getCitizenNPC(action, this.getNPC());
        if (citizen == null) {
            return;
        }
        citizen.destroy();
    }

    @Override
    protected void register(QuestAction<?, ?> action, QuestClient quester, Object value) {
        quester.getData().addCitizenNPC(action, this.getNPC(), (NPC)value);
    }

    @Override
    protected Object spawn(QuestAction<?, ?> action, QuestClient quester) {
        QuestNPC questNPC = this.getNPC();
        Location location = questNPC.getLocation().toBukkitLocation();
        Player player = quester.getPlayer();
        if (player == null) {
            return null;
        }
        location.add(0.5, 0.0, 0.5);
        Vector calculatedVector = player.getLocation().toVector().subtract(location.toVector());
        location.setDirection(calculatedVector);
        NPC citizen = this.getEntity().spawn(location);
        Entity entity = citizen.getEntity();
        citizen.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
        LookClose lookClose = (LookClose)citizen.getOrAddTrait(LookClose.class);
        lookClose.setRange(15.0);
        lookClose.setRealisticLooking(true);
        lookClose.toggle();
        Bukkit.getServer().getOnlinePlayers().forEach(onlinePlayer -> onlinePlayer.hideEntity(Core.getPlugin(), entity));
        player.showEntity(Core.getPlugin(), entity);
        entity.setInvulnerable(true);
        ((Gravity)citizen.getOrAddTrait(Gravity.class)).setHasGravity(false);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setCollidable(false);
        }
        return citizen;
    }

    @Override
    public void refund(QuestClient quester) {
    }

    @Override
    public void penalise(QuestClient quester) {
    }

    @Override
    public boolean isCurrentlyAt(LocationData locationData, QuesterData questerData, QuestAction<?, ?> action) {
        Location entityLocation = questerData.getCitizenNPC(action, this.getNPC()).getEntity().getLocation();
        return locationData.toBukkitLocation().distanceSquared(entityLocation) <= 1.0;
    }

    @Override
    public void walkTo(LocationData locationData, QuesterData questerData, WalkAction action) {
        this.getNPC().spawn(action, questerData.getQuester());
        NPC npc = questerData.getCitizenNPC(action, this.getNPC());
        ((Gravity)npc.getOrAddTrait(Gravity.class)).setHasGravity(true);
        Navigator navigator = npc.getNavigator();
        NavigatorParameters navigatorParameters = navigator.getLocalParameters();
        navigatorParameters.distanceMargin(0.0);
        navigatorParameters.destinationTeleportMargin(3.5);
        Location centeredTarget = locationData.toBukkitLocation().clone().add(0.5, 0.0, 0.5);
        navigator.setTarget(centeredTarget);
    }
}

