/*
 * Decompiled with CFR 0.152.
 */
package playerquests.product;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import playerquests.Core;
import playerquests.builder.quest.action.RewardItemAction;
import playerquests.builder.quest.action.option.ItemsOption;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.npc.EntityNPC;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.quest.QuestClient;
import playerquests.utility.ChatUtils;
import playerquests.utility.FileUtils;
import playerquests.utility.PluginUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.singleton.Database;
import playerquests.utility.singleton.PlayerQuests;
import playerquests.utility.singleton.QuestRegistry;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Quest {
    private String title = null;
    @JsonManagedReference
    private Map<String, QuestNPC> npcs = null;
    @JsonManagedReference
    private Map<String, QuestStage> stages = null;
    private UUID creator = null;
    private Boolean toggled;
    private String id;
    private List<StagePath> startPoints = List.of();

    public Quest(@JsonProperty(value="title") String title, @JsonProperty(value="npcs") Map<String, QuestNPC> npcs, @JsonProperty(value="stages") Map<String, QuestStage> stages, @JsonProperty(value="creator") UUID creator, @JsonProperty(value="id") String id, @JsonProperty(value="startpoints") List<StagePath> startpoints) {
        npcs.entrySet().removeIf(stage -> stage.getValue() == null);
        stages.entrySet().removeIf(npc -> npc.getValue() == null);
        this.title = title;
        this.id = id;
        this.creator = creator;
        this.npcs = npcs;
        this.stages = stages;
        if (this.startPoints != null) {
            this.startPoints = startpoints;
        }
        if (this.stages != null) {
            stages.forEach((stageID, stage) -> {
                stage.setQuest(this);
                if (stageID.equals(stage.getID())) {
                    stage.setID((String)stageID);
                }
            });
        }
        if (this.npcs != null) {
            npcs.forEach((npc_id, npc) -> {
                npc.setQuest(this);
                if (npc_id.equals(npc.getID())) {
                    npc.setID((String)npc_id);
                }
            });
        }
    }

    public static Quest fromJSONString(String questJSON) {
        Quest quest = null;
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            quest = jsonObjectMapper.readValue(questJSON, Quest.class);
        }
        catch (JsonMappingException e) {
            ChatUtils.message("Could not map a quest JSON string to a valid quest product. " + String.valueOf(e)).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        catch (JsonProcessingException e) {
            ChatUtils.message("Malformed JSON attempted as a quest string. " + String.valueOf(e)).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        if (quest == null) {
            return quest;
        }
        if (!PlayerQuests.getInstance().hasCitizens2() && quest.getNPCs().values().stream().anyMatch(npc -> npc.getAssigned() instanceof EntityNPC)) {
            ChatUtils.message("Cannot load " + quest.getID() + " as it has EntityNPCs, but your server does not have the Citizens2 plugin").type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.PLAIN).target(ChatUtils.MessageTarget.CONSOLE).send();
            return null;
        }
        return quest;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, QuestNPC> getNPCs() {
        return this.npcs;
    }

    public Map<String, QuestStage> getStages() {
        return this.stages;
    }

    public UUID getCreator() {
        return this.creator;
    }

    @JsonIgnore
    public Player getCreatorPlayer() {
        UUID creatorUUID = this.getCreator();
        if (creatorUUID == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)creatorUUID);
    }

    @JsonProperty(value="id")
    public String getID() {
        return this.id;
    }

    public String toJSONString() throws JsonProcessingException {
        Quest product = this;
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(product);
    }

    public String save() {
        String questName = Core.getQuestsPath() + this.getID() + Core.getQuestFileExtension();
        Player player = null;
        if (this.creator != null) {
            player = Bukkit.getPlayer((UUID)this.creator);
        }
        try {
            Core.getQuestRegistry().submit(this);
            FileUtils.create(questName, this.toJSONString().getBytes());
            if (this.getStartPoints().isEmpty() && player != null) {
                ChatUtils.message(this.getTitle() + ": No start points set, so no actions or NPCs will show :)").type(ChatUtils.MessageType.NOTIF).style(ChatUtils.MessageStyle.PRETTY).player(player).send();
            }
            return "'" + this.title + "' was saved.";
        }
        catch (IOException e) {
            ChatUtils.MessageBuilder errorMessage = ChatUtils.message(e.getMessage()).type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN);
            errorMessage.send();
            if (player != null) {
                errorMessage.player(player).send();
            }
            return "'" + this.title + "' could not save.";
        }
    }

    @JsonIgnore
    public boolean isToggled() {
        if (this.toggled == null) {
            this.toggled = Database.getInstance().getQuestToggled(this);
        }
        return this.toggled;
    }

    public void toggle() {
        this.toggle(this.toggled == false);
    }

    public void toggle(boolean toEnable) {
        if (toEnable && !this.isAllowed()) {
            toEnable = false;
        }
        if (toEnable) {
            toEnable = QuestRegistry.getInstance().toggle(this);
        } else {
            QuestRegistry.getInstance().untoggle(this);
        }
        this.toggled = toEnable;
        Database.getInstance().setQuestToggled(this, toEnable);
    }

    @JsonIgnore
    public boolean isValid() {
        UUID questCreator = this.creator;
        Player player = null;
        ChatUtils.MessageBuilder response = ChatUtils.message("Something is wrong with the quest").type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN);
        boolean isValid = true;
        if (questCreator != null) {
            player = Bukkit.getPlayer((UUID)questCreator);
            response.player(player).style(ChatUtils.MessageStyle.PRETTY);
        }
        if (this.title == null) {
            response.content("A quest has no title");
            isValid = false;
        }
        if (!isValid) {
            response.send();
        }
        return isValid;
    }

    @JsonIgnore
    public boolean isAllowed() {
        UUID questCreator = this.creator;
        Player player = null;
        ChatUtils.MessageBuilder response = ChatUtils.message("Cannot enable the quest").type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN);
        boolean isAllowed = true;
        if (questCreator != null) {
            player = Bukkit.getPlayer((UUID)questCreator);
            response.player(player).style(ChatUtils.MessageStyle.PRETTY);
        }
        if (player == null) {
            response.target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN);
        }
        if (!(isAllowed = PluginUtils.getPredictiveInventory(this, QuestRegistry.getInstance().getInventory(this)).entrySet().stream().noneMatch(entry -> {
            Integer amount = (Integer)entry.getValue();
            if (amount < 0) {
                response.content(((TextComponent)Component.empty().append((Component)Component.text((String)String.format("The '%s' quest is missing some stock. ", this.title)))).append(Component.text((String)"This might be because you have a reward greater than what's in the quest inventory.").color((TextColor)NamedTextColor.GRAY)));
                return true;
            }
            return false;
        }))) {
            response.send();
        }
        return isAllowed;
    }

    @JsonIgnore
    public String toString() {
        return String.format("%s=%s", super.toString(), this.getID());
    }

    public boolean refund() {
        if (this.creator == null) {
            return true;
        }
        Player player = Bukkit.getPlayer((UUID)this.creator);
        if (player == null) {
            throw new IllegalStateException("No player to refund quest to.");
        }
        QuestClient quester = QuestRegistry.getInstance().getQuester(player);
        this.getNPCs().values().stream().forEach(npc -> npc.refund(quester));
        ChatUtils.message("Returned items from quest.").player(player).style(ChatUtils.MessageStyle.PRETTY).send();
        return true;
    }

    @JsonIgnore
    public Map<ItemSerialisable, Integer> getRequiredInventory() {
        HashMap<ItemSerialisable, Integer> requiredInventory = new HashMap<ItemSerialisable, Integer>();
        this.getStages().values().forEach(stage -> stage.getActions().values().forEach(action -> {
            if (!List.of(RewardItemAction.class).contains(action.getClass())) {
                return;
            }
            action.getData().getOption(ItemsOption.class).get().getItems().forEach((itemSerialisable, amount) -> requiredInventory.put((ItemSerialisable)itemSerialisable, (Integer)amount));
        }));
        return requiredInventory;
    }

    @JsonProperty(value="startpoints")
    public List<StagePath> getStartPoints() {
        if (this.startPoints == null) {
            return List.of();
        }
        return this.startPoints;
    }
}

