/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import playerquests.product.Quest;
import playerquests.utility.serialisable.ItemSerialisable;

public class PluginUtils {
    private PluginUtils() {
    }

    public static void validateParams(List<Object> params, Class<?> ... expectedTypes) throws IllegalArgumentException {
        Objects.requireNonNull(params, "Params cannot be null");
        if (params.size() != expectedTypes.length) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        IntStream.range(0, params.size()).filter(i -> !expectedTypes[i].isInstance(params.get(i))).findFirst().ifPresent(index -> {
            throw new IllegalArgumentException("Parameter at index " + index + " does not match the expected type");
        });
    }

    public static Map<ItemSerialisable, Integer> getPredictiveInventory(Quest quest, Map<ItemSerialisable, Integer> inventory) {
        LinkedHashMap<ItemSerialisable, Integer> predictiveInventory = new LinkedHashMap<ItemSerialisable, Integer>();
        Map<ItemSerialisable, Integer> requiredInventory = quest.getRequiredInventory();
        if (requiredInventory != null) {
            requiredInventory.forEach((item, amount) -> predictiveInventory.merge((ItemSerialisable)item, -amount.intValue(), Integer::sum));
        }
        if (inventory != null) {
            inventory.forEach((item, amount) -> predictiveInventory.merge((ItemSerialisable)item, (Integer)amount, Integer::sum));
        }
        return predictiveInventory;
    }
}

