/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.Serialisable;
import playerquests.utility.serialisable.data.EntityData;

public class EntitySerialisable
implements Serialisable<EntityData, Entity> {
    private EntityData entityData;
    private Map<String, String> properties;

    public EntitySerialisable(String string) {
        this.fromString(string);
    }

    private EntitySerialisable(EntityData entityData, Map<String, String> properties) {
        this.entityData = Objects.requireNonNull(entityData);
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public static EntitySerialisable fromEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        EntityData data = (EntityData)EntityData.GENERIC.fromSource(entity.getType());
        if (data == null) {
            throw new IllegalArgumentException("Unsupported entity type " + String.valueOf(entity.getType()));
        }
        return new EntitySerialisable(data, data.extractProperties(entity));
    }

    @Override
    public EntityData getData() {
        return this.entityData;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntitySerialisable other = (EntitySerialisable)obj;
        return Objects.equals(this.entityData, other.entityData) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.entityData, this.properties);
    }

    public NPC spawn(Location location) {
        try {
            return this.getData().spawn(this.getProperties(), location);
        }
        catch (NoSuchElementException e) {
            EntitySerialisable replacementObject = (EntitySerialisable)this.getData().getFallback();
            ChatUtils.message("The " + this.getData().toString() + " entity was changed or removed. " + e.getMessage() + ": Trying to fallback to " + replacementObject.getData().toString()).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.SIMPLE).type(ChatUtils.MessageType.ERROR).send();
            this.properties = replacementObject.getProperties();
            this.entityData = replacementObject.getData();
            return this.spawn(location);
        }
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return this.entityData.name();
        }
        return this.entityData.name() + this.properties.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";", "[", "]"));
    }

    @Override
    public EntityData getGenericData() {
        return EntityData.GENERIC;
    }

    @Override
    public void setData(EntityData data) {
        this.entityData = data;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public EntityData getEnumValue(String baseString) {
        return EntityData.getEnum(baseString);
    }

    @Override
    public Map<String, String> washProperties(Map<String, String> properties) {
        World world = (World)Bukkit.getServer().getWorlds().getFirst();
        Location location = new Location(world, 0.0, 0.0, 0.0);
        NPC citizen = this.entityData.spawn(properties, location);
        Entity entity = citizen.getEntity();
        entity.setInvisible(true);
        properties = this.entityData.extractProperties(entity);
        citizen.destroy();
        return properties;
    }
}

