/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.Serialisable;
import playerquests.utility.serialisable.data.ItemData;

public final class ItemSerialisable
implements Serialisable<ItemData, ItemStack> {
    private ItemData itemData;
    private Map<String, String> properties;

    public ItemSerialisable(String string) {
        this.fromString(string);
    }

    private ItemSerialisable(ItemData itemData, Map<String, String> properties) {
        this.itemData = Objects.requireNonNull(itemData);
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return this.itemData.name();
        }
        return this.itemData.name() + this.properties.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";", "[", "]"));
    }

    public String getName() {
        return this.getData().getName(this.getProperties());
    }

    public ItemStack toItemStack() {
        try {
            return (ItemStack)this.itemData.create(this.properties);
        }
        catch (NoSuchElementException e) {
            ItemSerialisable replacementObject = (ItemSerialisable)this.itemData.getFallback();
            ChatUtils.message("The " + this.itemData.toString() + " item material was changed or removed. " + e.getMessage() + ": Trying to fallback to " + replacementObject.getData().toString()).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.SIMPLE).type(ChatUtils.MessageType.ERROR).send();
            this.properties = replacementObject.getProperties();
            this.itemData = replacementObject.getData();
            return this.toItemStack();
        }
    }

    public static ItemSerialisable fromItemStack(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        ItemData data = (ItemData)ItemData.GENERIC.fromSource(item.getType());
        if (data == null) {
            throw new IllegalArgumentException("Unsupported item type " + String.valueOf(item.getType()));
        }
        return new ItemSerialisable(data, data.extractProperties(item));
    }

    @Override
    public ItemData getData() {
        return this.itemData;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemSerialisable other = (ItemSerialisable)obj;
        return Objects.equals(this.itemData, other.itemData) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.itemData, this.properties);
    }

    public static boolean hasRequiredItems(Player player, Map<ItemSerialisable, Integer> requiredItems) {
        Map<ItemSerialisable, Integer> inventory = Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).collect(Collectors.toMap(ItemSerialisable::fromItemStack, ItemStack::getAmount, Integer::sum));
        return requiredItems.entrySet().stream().allMatch(entry -> {
            Integer available = (Integer)inventory.get(entry.getKey());
            return available != null && available >= (Integer)entry.getValue();
        });
    }

    @Override
    public ItemData getEnumValue(String baseString) {
        return ItemData.getEnum(baseString);
    }

    @Override
    public ItemData getGenericData() {
        return ItemData.GENERIC;
    }

    @Override
    public void setData(ItemData data) {
        this.itemData = data;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public Map<String, String> washProperties(Map<String, String> properties) {
        this.setProperties(properties);
        ItemStack itemStack = this.toItemStack();
        return this.itemData.extractProperties(itemStack);
    }

    public static class Builder {
        private final ItemData itemData;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder(ItemData itemData) {
            this.itemData = itemData;
        }

        public Builder with(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public ItemSerialisable build() {
            return new ItemSerialisable(this.itemData, this.properties);
        }
    }
}

