/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import playerquests.utility.serialisable.data.DataWrapper;
import playerquests.utility.serialisable.data.ItemData;

public interface Serialisable<D extends Enum<D>, S> {
    default public Serialisable<D, S> fromString(String string) {
        if (this.isGeneric(string)) {
            this.toGeneric(string);
            return this;
        }
        String[] parts = this.getStringParts(string);
        Map<String, String> keyValues = this.getStringKeyValues(parts);
        String baseString = parts[0];
        String typeString = keyValues.get(((DataWrapper)this.getGenericData()).getTypeKey());
        this.setData(this.fromGeneric(typeString, baseString));
        this.setProperties(this.washProperties(keyValues));
        return this;
    }

    public D getEnumValue(String var1);

    default public String[] getStringParts(String string) {
        return string.split("[\\[\\]]");
    }

    default public Map<String, String> getStringKeyValues(String[] stringParts) {
        return Arrays.stream(stringParts[1].split(";")).map(pair -> pair.split(":")).map(kv -> {
            if (kv[0].equals(((DataWrapper)this.getGenericData()).getTypeKey())) {
                return new String[]{kv[0], kv[1].toUpperCase()};
            }
            return kv;
        }).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1]));
    }

    public D getData();

    public D getGenericData();

    public void setData(D var1);

    public Map<String, String> getProperties();

    public void setProperties(Map<String, String> var1);

    default public String getAsString() {
        if (this.getProperties().isEmpty()) {
            return ((Enum)this.getData()).name();
        }
        return ((Enum)this.getData()).name() + this.getProperties().entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";", "[", "]"));
    }

    default public boolean isGeneric(String string) {
        return !string.contains("[");
    }

    default public D fromGeneric(String typeString, String baseString) {
        if (typeString != null && !typeString.isEmpty()) {
            return this.getGenericData();
        }
        return this.getEnumValue(baseString);
    }

    default public void toGeneric(String string) {
        this.setData(this.getGenericData());
        this.setProperties(Map.of(ItemData.GENERIC.getTypeKey(), string));
    }

    public Map<String, String> washProperties(Map<String, String> var1);
}

