/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable.data;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.bukkit.Location;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.Serialisable;

public interface DataWrapper<S, T, K> {
    public T create(Map<String, String> var1) throws NoSuchElementException;

    public Map<String, String> extractProperties(S var1);

    public String getName(Map<String, String> var1);

    public boolean includes(K var1);

    public String getTypeKey();

    public Set<K> getWarnedTypes();

    public Map<K, DataWrapper<S, T, K>> getSpecialMappings();

    public DataWrapper<S, T, K> getGenericHandler();

    default public String formatText(String text) {
        return WordUtils.capitalizeFully(text.replaceAll("_+", " "));
    }

    default public void warnUnimplemented(K key) {
        if (!this.getWarnedTypes().contains(key)) {
            this.getWarnedTypes().add(key);
            ChatUtils.message(this.getClass().getEnclosingClass().getSimpleName() + ": " + String.valueOf(key) + " is currently only generic. If you are wanting any missing variation/customisation, let sammypanda know! :)").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.WARN).style(ChatUtils.MessageStyle.SIMPLE).send();
        }
    }

    default public DataWrapper<S, T, K> fromSource(K key) {
        DataWrapper<S, T, K> specialHandler = this.getSpecialMappings().get(key);
        if (specialHandler != null) {
            return specialHandler;
        }
        return this.getGenericHandler();
    }

    public Object spawn(Map<String, String> var1, Location var2);

    public Serialisable<?, ?> getFallback();
}

