/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.singleton;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import playerquests.Core;
import playerquests.builder.quest.data.StagePath;
import playerquests.client.quest.QuestDiary;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.MigrationUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.serialisable.data.ItemData;
import playerquests.utility.singleton.PlayerQuests;

public class Database {
    private static final Database instance = new Database();
    private static Connection connection;
    private boolean isFresh = false;

    private Database() {
    }

    public static Database getInstance() {
        return instance;
    }

    private synchronized Connection getConnection() {
        try {
            if (connection != null && !connection.isClosed()) {
                return connection;
            }
        }
        catch (SQLException e) {
            ChatUtils.message("Could not check if existing connection was closed: " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        try {
            connection = DriverManager.getConnection("jdbc:sqlite:plugins/PlayerQuests/playerquests.db");
            return connection;
        }
        catch (SQLException e) {
            ChatUtils.message("Could not connect to or create database: " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            return null;
        }
    }

    public boolean canConnect() {
        return this.getConnection() != null;
    }

    public synchronized Database init() {
        String dbVersion = this.getPluginVersion();
        String version = "0.0";
        try (InputStream input = this.getClass().getResourceAsStream("/plugin.properties");){
            Properties props = new Properties();
            props.load(input);
            version = props.getProperty("version");
        }
        catch (Exception e) {
            ChatUtils.message("Failed to read PlayerQuests version property from pom: " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        try (Connection c = this.getConnection();
             Statement statement = c.createStatement();){
            String pluginTableSQL = "CREATE TABLE IF NOT EXISTS plugin (plugin TEXT PRIMARY KEY,version TEXT NOT NULL,CONSTRAINT single_row_constraint UNIQUE (plugin));";
            statement.execute(pluginTableSQL);
            String playersTableSQL = "CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY NOT NULL);";
            statement.execute(playersTableSQL);
            String questsTableSQL = "CREATE TABLE IF NOT EXISTS quests (id TEXT PRIMARY KEY,toggled BOOLEAN NOT NULL DEFAULT TRUE,inventory TEXT NOT NULL DEFAULT '');";
            statement.execute(questsTableSQL);
            String diariesTableSQL = "CREATE TABLE IF NOT EXISTS diaries (id TEXT PRIMARY KEY NOT NULL,player TEXT UNIQUE,FOREIGN KEY (player) REFERENCES players(uuid));";
            statement.execute(diariesTableSQL);
            String diaryEntriesTableSQL = "CREATE TABLE IF NOT EXISTS diary_entries (diary TEXT NOT NULL,quest TEXT NOT NULL,action TEXT NOT NULL,completion BOOLEAN NOT NULL,FOREIGN KEY (quest) REFERENCES quests(id),FOREIGN KEY (diary) REFERENCES diaries(id),UNIQUE(diary, quest, action));";
            statement.execute(diaryEntriesTableSQL);
            this.migrate(version, dbVersion);
            this.isFresh();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not initialise the database: " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        Core.getQuestRegistry().loadQuestInventories();
        return this;
    }

    private synchronized void migrate(String version, String versionDB) {
        ChatUtils.MessageBuilder alert = ChatUtils.message("Could not retrieve latest version. Maybe you're offline or GitLab is unavailable?").style(ChatUtils.MessageStyle.PRETTY).target(ChatUtils.MessageTarget.WORLD).type(ChatUtils.MessageType.WARN);
        try (InputStream input = this.getClass().getResourceAsStream("/plugin.properties");){
            String content;
            Properties props = new Properties();
            props.load(input);
            URL url = new URI(props.getProperty("versionEndpoint")).toURL();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                content = in.lines().reduce("", (accumulator, actual) -> accumulator + actual);
            }
            JsonNode tree = new ObjectMapper().readTree(content);
            String latest = tree.findValue("tag_name").textValue();
            if (!("v" + version).equals(latest)) {
                alert.content("A new release is available! " + latest).send();
            }
        }
        catch (IOException | URISyntaxException e) {
            alert.send();
            ChatUtils.message(e.toString()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.SIMPLE).send();
        }
        if (versionDB.equals(version)) {
            return;
        }
        try (Connection c = this.getConnection();
             Statement statement = c.createStatement();){
            StringBuilder query = new StringBuilder();
            switch (version) {
                case "0.11": 
                case "0.10.8": 
                case "0.10.7": 
                case "0.10.6": 
                case "0.10.5": 
                case "0.10.4": {
                    query.append(MigrationUtils.getMigration("0.10.4"));
                }
                case "0.10.3": 
                case "0.10.2": 
                case "0.10.1": {
                    query.append(MigrationUtils.getMigration("0.10.1"));
                }
                case "0.10": {
                    query.append(MigrationUtils.getMigration("0.10"));
                }
                case "0.9.2": 
                case "0.9.1": 
                case "0.9": 
                case "0.8.1": 
                case "0.8": {
                    query.append(MigrationUtils.getMigration("0.8"));
                }
                case "0.7": {
                    query.append(MigrationUtils.getMigration("0.7"));
                }
                case "0.6": 
                case "0.5.2": 
                case "0.5.1": {
                    query.append(MigrationUtils.getMigration("0.5.1"));
                }
                case "0.5": 
                case "0.4": {
                    query.append(MigrationUtils.getMigration("0.4"));
                }
            }
            statement.executeUpdate(query.toString());
        }
        catch (SQLException e) {
            ChatUtils.message("No database found, creating one. If you know you already have a database, try restarting.").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.NOTIF).send();
        }
        this.setPluginVersion(version);
        ChatUtils.message("You're on v" + version + "! https://sammypanda.moe/docs/playerquests/v" + version).target(ChatUtils.MessageTarget.WORLD).type(ChatUtils.MessageType.NOTIF).send();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized String getPluginVersion() {
        if (!Files.exists(Paths.get("plugins/PlayerQuests/playerquests.db", new String[0]), new LinkOption[0])) {
            this.isFresh = true;
            return "0.0";
        }
        try (Connection c = this.getConnection();){
            String string;
            block15: {
                PreparedStatement statement = c.prepareStatement("SELECT version FROM plugin WHERE plugin = 'PlayerQuests';");
                try {
                    ResultSet results = statement.executeQuery();
                    string = results.getString("version");
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return string;
        }
        catch (SQLException e) {
            ChatUtils.message("Could not find the quest version in the db " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            this.isFresh = true;
            return "0.0";
        }
    }

    private synchronized void setPluginVersion(String version) {
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("    INSERT INTO plugin (plugin, version)\n    VALUES ('PlayerQuests', ?)\n    ON CONFLICT(plugin)\n    DO UPDATE SET version = excluded.version;\n");){
            preparedStatement.setString(1, version);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not insert or set the quest version in the db " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    public synchronized void addPlayer(UUID uuid) {
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("INSERT OR IGNORE INTO players (uuid) VALUES (?) RETURNING *;");){
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not add the user " + Bukkit.getServer().getPlayer(uuid).getName() + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized ResultSet getDiary(Integer dbPlayerID) {
        try (Connection c = this.getConnection();){
            ResultSet resultSet;
            block14: {
                PreparedStatement preparedStatement = c.prepareStatement("SELECT id FROM diaries WHERE player = ?");
                try {
                    preparedStatement.setInt(1, dbPlayerID);
                    resultSet = preparedStatement.executeQuery();
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return resultSet;
        }
        catch (SQLException e) {
            ChatUtils.message("Could not find a diary for db player ID: " + dbPlayerID + ": " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            return null;
        }
    }

    public synchronized Database addPlayers(List<UUID> uuids) {
        for (UUID uuid : uuids) {
            this.addPlayer(uuid);
        }
        return this;
    }

    public synchronized List<String> getAllQuests() {
        ArrayList<String> ids = new ArrayList<String>();
        try (Connection c = this.getConnection();
             Statement statement = c.createStatement();){
            String allQuestsSQL = "SELECT id FROM quests;";
            ResultSet result = statement.executeQuery(allQuestsSQL);
            while (result.next()) {
                ids.add(result.getString("id"));
            }
        }
        catch (SQLException e) {
            ChatUtils.message("Could not retrieve quests from database. " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        return ids;
    }

    public synchronized void addQuest(String id) {
        if (id == null) {
            return;
        }
        String existingId = this.getQuest(id);
        if (existingId != null) {
            return;
        }
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("INSERT INTO quests (id) VALUES (?);");){
            preparedStatement.setString(1, id);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not add the quest " + id + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized String getQuest(String id) {
        if (id == null) {
            return null;
        }
        try (Connection c = this.getConnection();){
            String string;
            block15: {
                PreparedStatement preparedStatement = c.prepareStatement("SELECT id FROM quests WHERE id = ?;");
                try {
                    preparedStatement.setString(1, id);
                    ResultSet results = preparedStatement.executeQuery();
                    string = results.getString("id");
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return string;
        }
        catch (SQLException e) {
            ChatUtils.message("Could not get the quest " + id + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized Boolean getQuestToggled(Quest quest) {
        try (Connection c = this.getConnection();){
            Boolean bl;
            block15: {
                PreparedStatement preparedStatement = c.prepareStatement("SELECT toggled FROM quests WHERE id = ?;");
                try {
                    preparedStatement.setString(1, quest.getID());
                    ResultSet results = preparedStatement.executeQuery();
                    Boolean result = false;
                    if (results.next()) {
                        result = results.getBoolean("toggled");
                    }
                    bl = result;
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            ChatUtils.message("Could not get the quest toggle status " + quest.toString() + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            return false;
        }
    }

    public synchronized void setQuestToggled(Quest quest, Boolean state) {
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("UPDATE quests SET toggled = ? WHERE id = ?;");){
            preparedStatement.setBoolean(1, state);
            preparedStatement.setString(2, quest.getID());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not toggle the quest " + quest.toString() + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    public synchronized void removeQuest(String id) {
        if (id == null) {
            return;
        }
        try (Connection c = this.getConnection();){
            String removeQuestSQL = "DELETE FROM quests WHERE id = ?;";
            PreparedStatement preparedStatement = c.prepareStatement(removeQuestSQL);
            preparedStatement.setString(1, id);
            preparedStatement.execute();
            String removeDiaryQuestSQL = "DELETE FROM diary_entries WHERE quest = ?;";
            preparedStatement = c.prepareStatement(removeDiaryQuestSQL);
            preparedStatement.setString(1, id);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not remove the quest " + id + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    public void setQuestInventory(Quest quest, Map<ItemSerialisable, Integer> inventory) {
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("INSERT INTO quests (id, inventory) VALUES (?, ?) ON CONFLICT(id) DO UPDATE SET inventory = EXCLUDED.inventory");){
            preparedStatement.setString(1, quest.getID());
            preparedStatement.setString(2, inventory.toString());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not toggle the quest " + quest.toString() + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    public synchronized Map<String, Map<ItemSerialisable, Integer>> getAllQuestInventories() {
        HashMap<String, Map<ItemSerialisable, Integer>> inventories = new HashMap<String, Map<ItemSerialisable, Integer>>();
        try (Connection c = this.getConnection();
             Statement statement = c.createStatement();){
            String allQuestsSQL = "SELECT id, inventory FROM quests;";
            ResultSet result = statement.executeQuery(allQuestsSQL);
            while (result.next()) {
                Map<ItemSerialisable, Integer> inventoryMap = this.parseInventoryString(result.getString("inventory"));
                inventories.put(result.getString("id"), inventoryMap);
            }
        }
        catch (SQLException e) {
            ChatUtils.message("Could not retrieve quests from database. " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        return inventories;
    }

    private Map<ItemSerialisable, Integer> parseInventoryString(String inventoryString) {
        String[] pairs;
        HashMap<ItemSerialisable, Integer> inventoryMap = new HashMap<ItemSerialisable, Integer>();
        for (String pair : pairs = inventoryString.replaceAll("[{}]", "").split(",")) {
            String itemString;
            ItemSerialisable itemSerialisable;
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2 || (itemSerialisable = new ItemSerialisable(itemString = keyValue[0].trim())).getData().equals(ItemData.AIR)) continue;
            try {
                Integer quantity = Integer.parseInt(keyValue[1].trim());
                inventoryMap.put(itemSerialisable, quantity);
            }
            catch (NumberFormatException e) {
                ChatUtils.message("Invalid quantity format: " + keyValue[1]).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            }
        }
        return inventoryMap;
    }

    public synchronized void setQuestDiary(QuestDiary diary) {
        Player player = diary.getQuestClient().getPlayer();
        String playerUUIDString = player.getUniqueId().toString();
        String diaryID = diary.getID();
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("INSERT OR IGNORE INTO diaries (id, player) VALUES (?, ?)");){
            preparedStatement.setString(1, diaryID);
            preparedStatement.setString(2, playerUUIDString);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not add a quest diary to the database " + diaryID + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    public synchronized Map<Quest, List<Map<StagePath, Boolean>>> getDiaryEntries(QuestDiary diary) {
        HashMap<Quest, List<Map<StagePath, Boolean>>> diaryEntries = new HashMap<Quest, List<Map<StagePath, Boolean>>>();
        String diaryID = diary.getID();
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("SELECT diary, quest, action, completion FROM diary_entries WHERE diary = ?;");){
            preparedStatement.setString(1, diaryID);
            ResultSet result = preparedStatement.executeQuery();
            while (result.next()) {
                Quest quest = Core.getQuestRegistry().getQuest(result.getString("quest"));
                StagePath path = new StagePath(result.getString("action"));
                Map<StagePath, Boolean> completionMap = Map.of(path, result.getBoolean("completion"));
                List entriesList = diaryEntries.getOrDefault(quest, new ArrayList());
                entriesList.add(completionMap);
                diaryEntries.put(quest, entriesList);
            }
        }
        catch (SQLException e) {
            ChatUtils.message("Could not retrieve diary entries from database for " + diaryID + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
        return diaryEntries;
    }

    public synchronized void setDiaryEntryCompletion(String diaryID, String questID, StagePath actionPath, boolean completionState) {
        try (Connection c = this.getConnection();
             PreparedStatement preparedStatement = c.prepareStatement("REPLACE INTO diary_entries (diary, quest, action, completion) VALUES (?, ?, ?, ?)");){
            preparedStatement.setString(1, diaryID);
            preparedStatement.setString(2, questID);
            preparedStatement.setString(3, actionPath.toString());
            preparedStatement.setBoolean(4, completionState);
            preparedStatement.execute();
        }
        catch (SQLException e) {
            ChatUtils.message("Could not add a quest diary to the database " + diaryID + ". " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
        }
    }

    private void isFresh() {
        if (!this.isFresh) {
            return;
        }
        PlayerQuests.getPlayerListener().isFresh();
    }
}

