/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.singleton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ObjIntConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import playerquests.Core;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.FileUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.singleton.Database;
import playerquests.utility.singleton.PlayerQuests;

public class QuestRegistry {
    private static final QuestRegistry instance = new QuestRegistry();
    private final Map<String, Quest> registry = new HashMap<String, Quest>();
    private Map<String, Map<ItemSerialisable, Integer>> inventories = new HashMap<String, Map<ItemSerialisable, Integer>>();
    private List<QuestClient> questers = new ArrayList<QuestClient>();

    private QuestRegistry() {
    }

    public void loadQuestInventories() {
        this.inventories = Database.getInstance().getAllQuestInventories();
    }

    public static QuestRegistry getInstance() {
        return instance;
    }

    public void submit(Quest quest) {
        String questID = quest.getID();
        if (!quest.isValid()) {
            ChatUtils.message("Not installing an invalid quest: " + questID).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN).type(ChatUtils.MessageType.WARN);
            return;
        }
        if (this.registry.values().removeIf(registryQuest -> registryQuest.getID().equals(questID))) {
            this.delete(quest, false, false, false);
        }
        this.add(questID, quest);
        if (!quest.isToggled()) {
            this.untoggle(quest);
            return;
        }
        this.toggle(quest);
    }

    public boolean delete(Quest quest) {
        return this.delete(quest, true, true, true);
    }

    public boolean delete(Quest quest, boolean fromFS, boolean withRefund, boolean fromDB) {
        String questID = quest.getID();
        UUID creator = quest.getCreator();
        try {
            this.registry.remove(questID);
            PlayerQuests.remove(quest);
            if (fromFS) {
                FileUtils.delete(Core.getQuestsPath() + quest.getID() + Core.getQuestFileExtension());
            }
            if (withRefund) {
                quest.refund();
            }
            if (fromDB) {
                Database.getInstance().removeQuest(quest.getID());
            }
        }
        catch (IOException e) {
            ChatUtils.MessageBuilder errorMessage = ChatUtils.message("Could not delete the " + quest.getTitle() + " quest. " + String.valueOf(e)).type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE);
            if (creator != null) {
                errorMessage.player(Bukkit.getPlayer((UUID)creator)).style(ChatUtils.MessageStyle.PRETTY);
            }
            errorMessage.send();
            return false;
        }
        return true;
    }

    private void add(String questID, Quest quest) {
        this.registry.put(questID, quest);
        Database.getInstance().addQuest(questID);
    }

    public boolean toggle(Quest quest) {
        if (!this.canPlaceNPCs(quest)) {
            return false;
        }
        Database.getInstance().setQuestToggled(quest, true);
        PlayerQuests.install(quest);
        return true;
    }

    private boolean canPlaceNPCs(Quest quest) {
        return quest != null;
    }

    public void untoggle(Quest quest) {
        Database.getInstance().setQuestToggled(quest, false);
        PlayerQuests.remove(quest);
    }

    public Map<String, Quest> getAllQuests() {
        return this.registry;
    }

    public void clear() {
        this.clearQuests();
        this.clearQuesters();
    }

    public Quest getQuest(String questID) {
        return this.getQuest(questID, false);
    }

    public Quest getQuest(String questID, boolean searchFS) {
        Quest result = this.getAllQuests().get(questID);
        if (result == null && searchFS) {
            ChatUtils.message("Quest registry could not find quest: " + questID + ". It'll now search for it in the quest files.").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            try {
                result = Quest.fromJSONString(FileUtils.get(Core.getQuestsPath() + questID + Core.getQuestFileExtension()));
                if (result != null) {
                    this.submit(result);
                    result.toggle(false);
                }
            }
            catch (IOException e) {
                ChatUtils.message("Could not find the quest with ID: " + questID + " | " + e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            }
        }
        return result;
    }

    public boolean hasQuest(String questID, boolean searchFS) {
        boolean result;
        boolean bl = result = this.getAllQuests().get(questID) != null;
        if (!result && searchFS) {
            try {
                result = Quest.fromJSONString(FileUtils.get(Core.getQuestsPath() + questID + Core.getQuestFileExtension())).isValid();
            }
            catch (IOException e) {
                return false;
            }
        }
        return result;
    }

    public Map<ItemSerialisable, Integer> getInventory(Quest quest) {
        Map<ItemSerialisable, Integer> inventory = this.inventories.get(quest.getID());
        if (inventory == null) {
            inventory = new HashMap<ItemSerialisable, Integer>();
            this.setInventory(quest, inventory);
        }
        return inventory;
    }

    public void setInventory(Quest quest, Map<ItemSerialisable, Integer> inventory) {
        this.inventories.put(quest.getID(), inventory);
        Database.getInstance().setQuestInventory(quest, inventory);
    }

    public void updateInventoryItem(Quest quest, Map<ItemSerialisable, Integer> items) {
        this.updateInventoryItem(quest, items, null, false);
    }

    public void updateInventoryItem(Quest quest, Map<ItemSerialisable, Integer> items, Boolean invert) {
        this.updateInventoryItem(quest, items, null, invert);
    }

    public void updateInventoryItem(Quest quest, Map<ItemSerialisable, Integer> items, ObjIntConsumer<ItemSerialisable> callback, boolean invert) {
        HashMap<ItemSerialisable, Integer> stagingInventory = new HashMap<ItemSerialisable, Integer>(this.getInventory(quest));
        items.forEach((material, amount) -> {
            Integer inventoryCount;
            if (callback != null) {
                callback.accept((ItemSerialisable)material, (int)amount);
            }
            if (invert) {
                amount = -amount.intValue();
            }
            if ((inventoryCount = (Integer)stagingInventory.get(material)) == null) {
                stagingInventory.put((ItemSerialisable)material, (Integer)amount);
                return;
            }
            stagingInventory.put((ItemSerialisable)material, amount + inventoryCount);
        });
        this.setInventory(quest, stagingInventory);
    }

    public void createQuester(Player player) {
        QuestClient quester = new QuestClient(player);
        Optional<QuestClient> questClient = this.questers.stream().filter(qc -> qc.getPlayer().equals((Object)player)).findFirst();
        if (questClient.isPresent()) {
            this.questers.set(this.questers.indexOf(questClient.get()), quester);
            return;
        }
        Database.getInstance().addPlayer(player.getUniqueId());
    }

    public void clearQuesters() {
        this.questers.clear();
    }

    public void clearQuests() {
        this.registry.clear();
    }

    public void removeQuester(Player player) {
        QuestClient quester = this.getQuester(player);
        quester.clear();
        this.questers.remove(quester);
    }

    public void addQuester(QuestClient quester) {
        this.questers.add(quester);
    }

    public List<QuestClient> getAllQuesters() {
        return this.questers;
    }

    public QuestClient getQuester(Player player) {
        Optional<QuestClient> quester = this.questers.stream().filter(q -> q.getPlayer().equals((Object)player)).findFirst();
        if (quester.isEmpty()) {
            throw new IllegalStateException("Could not find a requested QuestClient, but all players should be assigned a QuestClient");
        }
        return quester.get();
    }
}

