/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import playerquests.client.ClientDirector;
import playerquests.utility.annotation.PlayerQuestsTest;

public abstract class TestUtility {
    protected ClientDirector clientDirector;
    protected List<TestResult> testResults = new ArrayList<TestResult>();

    protected TestUtility(ClientDirector clientDirector) {
        this.clientDirector = clientDirector;
    }

    public void runTests(Consumer<TestResult> onEach, Consumer<List<TestResult>> onSummary) {
        LinkedList<Method> remainingMethods = new LinkedList<Method>(Arrays.stream(this.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(PlayerQuestsTest.class)).toList());
        this.manageTests(new ArrayList<TestResult>(), remainingMethods, onEach, onSummary);
    }

    private void manageTests(List<TestResult> completed, LinkedList<Method> remainingMethods, Consumer<TestResult> onEach, Consumer<List<TestResult>> onSummary) {
        if (remainingMethods.isEmpty()) {
            onSummary.accept(completed);
            return;
        }
        Method testMethod = remainingMethods.pop();
        PlayerQuestsTest annotation = testMethod.getAnnotation(PlayerQuestsTest.class);
        String className = testMethod.getDeclaringClass().getSimpleName();
        String testName = testMethod.getName();
        String testLabel = annotation.label().isEmpty() ? testMethod.getName() : annotation.label();
        try {
            if (testMethod.getReturnType() != CompletableFuture.class) {
                return;
            }
            CompletableFuture futureResult = (CompletableFuture)testMethod.invoke((Object)this, new Object[0]);
            futureResult.whenComplete((result, throwable) -> {
                Boolean didTestPass = throwable == null && result != false;
                TestResult testResult = new TestResult(className, testName, testLabel, didTestPass, throwable != null ? throwable.getCause() : null);
                completed.add(testResult);
                onEach.accept(testResult);
                this.manageTests(completed, remainingMethods, onEach, onSummary);
            });
        }
        catch (Exception e) {
            TestResult testResult = new TestResult(className, testName, testLabel, false, e.getCause());
            completed.add(testResult);
            onEach.accept(testResult);
            this.manageTests(completed, remainingMethods, onEach, onSummary);
        }
    }

    public static class TestResult {
        public final String className;
        public final String testName;
        public final String testLabel;
        public final boolean didTestPass;
        public final Throwable testError;

        public TestResult(String className, String testName, String testLabel, boolean didTestPass, Throwable testError) {
            this.className = className;
            this.testName = testName;
            this.testLabel = testLabel;
            this.didTestPass = didTestPass;
            this.testError = testError;
        }

        public String toString() {
            return String.format("(%s) %s: %s - %s (%s)", this.className, this.testName, this.testLabel, this.didTestPass, this.testError);
        }
    }
}

