/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.test;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import playerquests.Core;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.condition.ConditionType;
import playerquests.builder.quest.action.option.NPCOption;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.annotation.PlayerQuestsTest;
import playerquests.utility.singleton.QuestRegistry;
import playerquests.utility.test.TestUtility;

public class Testquest
extends TestUtility {
    public Testquest(ClientDirector clientDirector) {
        super(clientDirector);
    }

    @PlayerQuestsTest(label="None action, no NPC")
    public CompletableFuture<Boolean> testNoneAction() {
        String testNoneActionString = "{\n    \"title\" : \"testNoneActionNoNPC\",\n    \"npcs\" : {\n        \"npc_0\" : {\n        \"id\" : \"npc_0\",\n        \"name\" : \"testNoneActionNPC\",\n        \"assigned\" : {\n            \"type\" : \"BlockNPC\",\n            \"value\" : \"minecraft:grass_block[snowy=false]\"\n        },\n        \"location\" : {\n            \"world\" : \"world\",\n            \"x\" : 0.0,\n            \"y\" : 202.0,\n            \"z\" : 0.0,\n            \"pitch\" : 0.0,\n            \"yaw\" : 0.0\n        }\n        }\n    },\n    \"stages\" : {\n        \"stage_0\" : {\n        \"id\" : \"stage_0\",\n        \"actions\" : {\n            \"action_0\" : {\n            \"type\" : \"NoneAction\",\n            \"data\" : {\n                \"id\" : \"action_0\",\n                \"next\" : [ ],\n                \"options\" : [ {\n                \"option\" : \"NPC\",\n                \"npc_id\" : null\n                } ],\n                \"conditions\" : [ ]\n            },\n            \"label\" : null\n            }\n        },\n        \"startpoints\" : [ ],\n        \"label\" : null\n        }\n    },\n    \"creator\" : null,\n    \"id\" : \"testNoneActionNoNPC\",\n    \"startpoints\" : [ \"stage_0.action_0\" ]\n}\n";
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Player player = this.clientDirector.getPlayer();
        Location originalLocation = player.getLocation();
        Location platformLocation = new Location(originalLocation.getWorld(), 1.0, 200.0, 0.0);
        BlockData prePlatformBlockData = platformLocation.getBlock().getBlockData();
        platformLocation.getBlock().setBlockData(Material.REDSTONE_BLOCK.createBlockData());
        Location npcLocation = new Location(originalLocation.getWorld(), 0.0, 202.0, 0.0);
        player.teleport(new Location(originalLocation.getWorld(), 1.0, 202.0, 0.5, 90.0f, 0.0f));
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
            npcLocation.getBlock().setBlockData(Material.AIR.createBlockData());
            Quest testNoneActionQuest = Quest.fromJSONString(testNoneActionString);
            testNoneActionQuest.save();
        });
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> {
            Quest quest = QuestRegistry.getInstance().getQuest("testNoneActionNoNPC");
            Boolean isNPCAir = npcLocation.getBlock().getType() == Material.AIR;
            Boolean wasQuestSaved = QuestRegistry.getInstance().hasQuest("testNoneActionNoNPC", true);
            player.teleport(originalLocation);
            platformLocation.getBlock().setBlockData(prePlatformBlockData);
            QuestRegistry.getInstance().delete(quest, true, false, true);
            result.complete(isNPCAir != false && wasQuestSaved != false);
        }, 50L);
        return result;
    }

    @PlayerQuestsTest(label="None action, with NPC")
    public CompletableFuture<Boolean> testNoneActionBlockNPC() {
        String testNoneActionBlockNPCString = "{\n    \"title\" : \"testNoneActionWithNPC\",\n    \"npcs\" : {\n        \"npc_0\" : {\n        \"id\" : \"npc_0\",\n        \"name\" : \"testNoneActionNPC\",\n        \"assigned\" : {\n            \"type\" : \"BlockNPC\",\n            \"value\" : \"minecraft:grass_block[snowy=false]\"\n        },\n        \"location\" : {\n            \"world\" : \"world\",\n            \"x\" : 0.0,\n            \"y\" : 202.0,\n            \"z\" : 0.0,\n            \"pitch\" : 0.0,\n            \"yaw\" : 0.0\n        }\n        }\n    },\n    \"stages\" : {\n        \"stage_0\" : {\n        \"id\" : \"stage_0\",\n        \"actions\" : {\n            \"action_0\" : {\n            \"type\" : \"NoneAction\",\n            \"data\" : {\n                \"id\" : \"action_0\",\n                \"next\" : [ ],\n                \"options\" : [ {\n                \"option\" : \"NPC\",\n                \"npc_id\" : \"npc_0\"\n                } ],\n                \"conditions\" : [ ]\n            },\n            \"label\" : null\n            }\n        },\n        \"startpoints\" : [ ],\n        \"label\" : null\n        }\n    },\n    \"creator\" : null,\n    \"id\" : \"testNoneActionWithNPC\",\n    \"startpoints\" : [ \"stage_0.action_0\" ]\n}\n";
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Player player = this.clientDirector.getPlayer();
        Location originalLocation = player.getLocation();
        Location platformLocation = new Location(originalLocation.getWorld(), 1.0, 200.0, 0.0);
        BlockData prePlatformBlockData = platformLocation.getBlock().getBlockData();
        platformLocation.getBlock().setBlockData(Material.REDSTONE_BLOCK.createBlockData());
        Location npcLocation = new Location(originalLocation.getWorld(), 0.0, 202.0, 0.0);
        player.teleport(new Location(originalLocation.getWorld(), 1.0, 202.0, 0.5, 90.0f, 0.0f));
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
            npcLocation.getBlock().setBlockData(Material.AIR.createBlockData());
            Quest testNoneActionQuest = Quest.fromJSONString(testNoneActionBlockNPCString);
            testNoneActionQuest.save();
        });
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> {
            Quest quest = QuestRegistry.getInstance().getQuest("testNoneActionWithNPC");
            QuestStage stage = (QuestStage)quest.getStages().values().toArray()[0];
            QuestAction action = (QuestAction)stage.getActions().values().toArray()[0];
            QuestNPC npc = action.getData().getOption(NPCOption.class).get().getNPC(quest);
            Boolean isNPCGrassBlock = npc.getBlock().getMaterial() == Material.GRASS_BLOCK;
            Boolean wasQuestSaved = QuestRegistry.getInstance().hasQuest("testNoneActionWithNPC", true);
            player.teleport(originalLocation);
            platformLocation.getBlock().setBlockData(prePlatformBlockData);
            QuestRegistry.getInstance().delete(quest, true, false, true);
            result.complete(isNPCGrassBlock != false && wasQuestSaved != false);
        }, 50L);
        return result;
    }

    @PlayerQuestsTest(label="No missing conditions in ConditionType enum")
    public CompletableFuture<Boolean> allConditionsAreInEnum() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Reflections reflections = new Reflections("playerquests.builder.quest.action.condition", new Scanner[0]);
        Set<Class<ActionCondition>> allConditions = reflections.getSubTypesOf(ActionCondition.class);
        Set enumConditionClasses = Arrays.stream(ConditionType.values()).map(ConditionType::getConditionClass).collect(Collectors.toSet());
        Set missing = allConditions.stream().filter(clazz -> !enumConditionClasses.contains(clazz)).collect(Collectors.toSet());
        result.complete(missing.isEmpty());
        return result;
    }
}

