/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.net.ServerSocket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.config.TunnelConfig;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.diagnostics.NetworkDiagnostics;
import org.texboobcat.tunnelyP2p.gui.AdvancedStatusScreen;
import org.texboobcat.tunnelyP2p.gui.TunnelStatusScreen;

public class TunnelCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnel").executes(TunnelCommands::showHelp)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"create").executes(ctx -> TunnelCommands.createTunnel((CommandContext<CommandSourceStack>)ctx, 4, 3600L, -1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"maxPeers", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), 3600L, -1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"ttl", (ArgumentType)LongArgumentType.longArg((long)60L, (long)86400L)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), LongArgumentType.getLong((CommandContext)ctx, (String)"ttl"), -1))).then(Commands.m_82129_((String)"mcPort", (ArgumentType)IntegerArgumentType.integer((int)1, (int)65535)).executes(ctx -> TunnelCommands.createTunnel((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxPeers"), LongArgumentType.getLong((CommandContext)ctx, (String)"ttl"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"mcPort")))))))).then(Commands.m_82127_((String)"token").executes(TunnelCommands::showToken))).then(Commands.m_82127_((String)"invite").executes(TunnelCommands::invitePlayer))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"connect").then(Commands.m_82129_((String)"token", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> TunnelCommands.connectToHost((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"token"))))).then(Commands.m_82127_((String)"paste").executes(TunnelCommands::connectFromClipboard)))).then(Commands.m_82127_((String)"stop").executes(TunnelCommands::stopSession))).then(Commands.m_82127_((String)"status").executes(TunnelCommands::showStatus))).then(Commands.m_82127_((String)"gui").executes(TunnelCommands::openGui))).then(Commands.m_82127_((String)"advanced").executes(TunnelCommands::openAdvancedGui))).then(Commands.m_82127_((String)"diagnostics").executes(TunnelCommands::runDiagnostics))).then(Commands.m_82127_((String)"help").executes(TunnelCommands::showHelp))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"reload").executes(TunnelCommands::reloadConfig))).then(Commands.m_82127_((String)"reset").executes(TunnelCommands::resetConfig))));
    }

    private static int createTunnel(CommandContext<CommandSourceStack> ctx, int maxPeers, long ttlSeconds, int overrideMcPort) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            int minecraftPort;
            String minecraftHost;
            int bindPort;
            block42: {
                if (manager.isHosting()) {
                    source.m_81352_((Component)Component.m_237113_((String)"\u00a7cAlready hosting a tunnel. Use /tunnel stop first."));
                    return 0;
                }
                if (manager.isConnected()) {
                    source.m_81352_((Component)Component.m_237113_((String)"\u00a7cAlready connected to a host. Use /tunnel stop first."));
                    return 0;
                }
                bindPort = 25566;
                minecraftHost = "localhost";
                int n = minecraftPort = overrideMcPort > 0 ? overrideMcPort : 25565;
                if (overrideMcPort > 0) {
                    int portToShow = minecraftPort;
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a77Using provided MC port: \u00a7f" + portToShow)), false);
                }
                try {
                    MinecraftServer server = source.m_81377_();
                    if (!server.m_6982_() && overrideMcPort <= 0) {
                        int detectedPort;
                        int requested;
                        block40: {
                            requested = TunnelCommands.findFreeTcpPort();
                            detectedPort = 0;
                            boolean published = false;
                            try {
                                try {
                                    Boolean bo;
                                    Object res = server.getClass().getMethod("isPublished", new Class[0]).invoke((Object)server, new Object[0]);
                                    if (res instanceof Boolean && (bo = (Boolean)res).booleanValue()) {
                                        published = true;
                                    }
                                }
                                catch (Throwable res) {
                                    // empty catch block
                                }
                                if (published) break block40;
                                try {
                                    boolean ok = (Boolean)server.getClass().getMethod("publishServer", GameType.class, Boolean.TYPE, Integer.TYPE).invoke((Object)server, GameType.SURVIVAL, true, requested);
                                    if (ok) {
                                        published = true;
                                        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aOpened LAN server (SURVIVAL, cheats ON) on port \u00a7f" + requested)), false);
                                    }
                                }
                                catch (NoSuchMethodException e1) {
                                    try {
                                        boolean ok = (Boolean)server.getClass().getMethod("openToLan", GameType.class, Boolean.TYPE, Integer.TYPE).invoke((Object)server, GameType.SURVIVAL, true, requested);
                                        if (ok) {
                                            published = true;
                                            source.m_288197_(() -> Component.m_237113_((String)("\u00a7aOpened LAN server (SURVIVAL, cheats ON) on port \u00a7f" + requested)), false);
                                        }
                                    }
                                    catch (Throwable ok) {}
                                }
                            }
                            catch (Throwable e1) {
                                // empty catch block
                            }
                        }
                        for (int i = 0; i < 50 && detectedPort <= 0; ++i) {
                            try {
                                String[] connAccessors;
                                String[] srvMethods;
                                for (String m : srvMethods = new String[]{"getPort", "getServerPort", "getPublishedPort"}) {
                                    try {
                                        int p = (Integer)server.getClass().getMethod(m, new Class[0]).invoke((Object)server, new Object[0]);
                                        if (p <= 0) continue;
                                        detectedPort = p;
                                        break;
                                    }
                                    catch (Throwable p) {
                                        // empty catch block
                                    }
                                }
                                if (detectedPort > 0) break;
                                for (String acc : connAccessors = new String[]{"getConnection", "getNetworkIo"}) {
                                    try {
                                        String[] connMethods;
                                        Object connection = server.getClass().getMethod(acc, new Class[0]).invoke((Object)server, new Object[0]);
                                        if (connection == null) continue;
                                        for (String cm : connMethods = new String[]{"getServerPort", "getLocalPort", "getPort"}) {
                                            try {
                                                int p = (Integer)connection.getClass().getMethod(cm, new Class[0]).invoke(connection, new Object[0]);
                                                if (p <= 0) continue;
                                                detectedPort = p;
                                                break;
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        if (detectedPort <= 0) continue;
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (detectedPort > 0) {
                            minecraftPort = detectedPort;
                        } else {
                            minecraftPort = requested;
                            System.out.println("[TunnelCommands] Falling back to requested LAN port: " + requested);
                        }
                        break block42;
                    }
                    int detected = server.m_7010_();
                    if (detected > 0) {
                        minecraftPort = detected;
                    }
                }
                catch (Throwable server) {
                    // empty catch block
                }
            }
            int mcPortFinal = minecraftPort;
            String token = manager.createHostSession(bindPort, minecraftHost, minecraftPort, maxPeers, ttlSeconds);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u00a7l\u2713 Tunnel Created!"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Max Peers: \u00a7f" + maxPeers)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77TTL: \u00a7f" + TunnelCommands.formatDuration(ttlSeconds))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Listening on port: \u00a7f" + bindPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Forwarding to local server: \u00a7flocalhost:" + mcPortFinal)), false);
            if (mcPortFinal <= 0 || mcPortFinal == 25565) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a78If singleplayer, ensure your world is opened to LAN or pass a port: /tunnel create <peers> <ttl> <mcPort>."), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77Detected LAN port: \u00a7f" + mcPortFinal)), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a78Tip: If singleplayer, open your world to LAN; this auto-detects the LAN port."), false);
            source.m_288197_(() -> Component.m_237113_((String)""), false);
            boolean showToken = TunnelCommands.shouldShowTokenInChat();
            if (showToken) {
                MutableComponent tokenComponent = Component.m_237113_((String)"\u00a7e\u00a7l[CLICK TO COPY TOKEN]").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, token)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u00a77Click to copy connection token"))));
                source.m_288197_(() -> TunnelCommands.lambda$createTunnel$17((Component)tokenComponent), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Share this token with friends to allow them to connect."), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Token generated (not shown for privacy)."), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Use \u00a7f/tunnel invite \u00a77to copy token to clipboard."), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Clients can use \u00a7f/tunnel connect paste \u00a77to read token from clipboard."), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to create tunnel: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int showToken(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cNo active tunnel. Use /tunnel create first."));
            return 0;
        }
        String token = manager.getActiveServer().getConnectionToken();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u00a7lConnection Token:"), false);
        boolean showToken = TunnelCommands.shouldShowTokenInChat();
        if (showToken) {
            MutableComponent tokenComponent = Component.m_237113_((String)"\u00a7e\u00a7l[CLICK TO COPY TOKEN]").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, token)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u00a77Click to copy connection token"))));
            source.m_288197_(() -> TunnelCommands.lambda$showToken$23((Component)tokenComponent), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Token hidden for privacy. Use \u00a7f/tunnel invite \u00a77to copy to clipboard."), false);
        }
        return 1;
    }

    private static int invitePlayer(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cNo active tunnel. Use /tunnel create first."));
            return 0;
        }
        String token = manager.getActiveServer().getConnectionToken();
        if (token == null || token.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cFailed to generate token."));
            return 0;
        }
        try {
            try {
                Minecraft.m_91087_().f_91068_.m_90911_(token);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Token copied to clipboard!"), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Share it with friends to let them connect."), false);
                return 1;
            }
            catch (Throwable mcError) {
                try {
                    Clipboard clipboard;
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                        clipboard.setContents(new StringSelection(token), null);
                        source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Token copied to clipboard!"), false);
                        source.m_288197_(() -> Component.m_237113_((String)"\u00a77Share it with friends to let them connect."), false);
                        return 1;
                    }
                }
                catch (Throwable toolkit) {
                    // empty catch block
                }
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cClipboard unavailable. Token must be copied manually."));
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77Token: \u00a7f" + token)), false);
                return 0;
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to copy to clipboard: " + errorMsg)));
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Token: \u00a7f" + token)), false);
            e.printStackTrace();
            return 0;
        }
    }

    private static int connectToHost(CommandContext<CommandSourceStack> ctx, String token) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            if (manager.isConnected()) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cAlready connected. Use /tunnel stop first."));
                return 0;
            }
            if (manager.isHosting()) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cCurrently hosting. Use /tunnel stop first."));
                return 0;
            }
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cThis command must be run by a player."));
                return 0;
            }
            int localPort = 25999;
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7eConnecting to host..."), false);
            manager.connectToHost(token, localPort, player.m_20148_(), player.m_7755_().getString());
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u00a7l\u2713 Connected!"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Local proxy: \u00a7flocalhost:" + localPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Add server: \u00a7f127.0.0.1:" + localPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7aConnect your Minecraft client to that address to join!"), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cConnection failed: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int connectFromClipboard(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        try {
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cThis command must be run by a player."));
                return 0;
            }
            if (manager.isConnected()) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cAlready connected. Use /tunnel stop first."));
                return 0;
            }
            if (manager.isHosting()) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cCurrently hosting. Use /tunnel stop first."));
                return 0;
            }
            String token = null;
            try {
                token = Minecraft.m_91087_().f_91068_.m_90876_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (token == null) {
                try {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Object data = cb.getData(DataFlavor.stringFlavor);
                    token = data != null ? data.toString() : null;
                }
                catch (Exception ex) {
                    source.m_81352_((Component)Component.m_237113_((String)("\u00a7cClipboard not available: " + ex.getMessage())));
                    return 0;
                }
            }
            if (token == null || token.trim().isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cClipboard is empty or doesn't contain a token."));
                return 0;
            }
            int localPort = 25999;
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7eConnecting to host..."), false);
            manager.connectToHost(token, localPort, player.m_20148_(), player.m_7755_().getString());
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u00a7l\u2713 Connected!"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Local proxy: \u00a7flocalhost:" + localPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Add server: \u00a7f127.0.0.1:" + localPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7aConnect your Minecraft client to that address to join!"), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cConnection failed: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static int stopSession(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting() && !manager.isConnected()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cNo active tunnel session."));
            return 0;
        }
        manager.stopAll();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Tunnel session stopped."), false);
        return 1;
    }

    private static int showStatus(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        TunnelManager manager = TunnelManager.getInstance();
        TunnelManager.SessionStatus status = manager.getStatus();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550 Tunnel Status \u2550\u2550\u2550"), false);
        if (!status.active) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Mode: \u00a7cInactive"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Use \u00a7f/tunnel create \u00a77to host or \u00a7f/tunnel connect \u00a77to join."), false);
            return 1;
        }
        if ("host".equals(status.mode)) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Mode: \u00a7aHost"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Connected Peers: \u00a7f" + status.peerCount)), false);
            if (status.peerCount > 0) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77Peers:"), false);
                for (PeerConnection peer : manager.getConnectedPeers()) {
                    String peerInfo = String.format("  \u00a7f%s \u00a77(\u2191 %s \u2193 %s)", peer.getPeerName(), TunnelCommands.formatBytes(peer.getBytesSent()), TunnelCommands.formatBytes(peer.getBytesReceived()));
                    source.m_288197_(() -> Component.m_237113_((String)peerInfo), false);
                }
            }
        } else if ("client".equals(status.mode)) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Mode: \u00a7aClient"), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Connected to: \u00a7f" + status.hostName)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Local proxy: \u00a7flocalhost:" + status.localPort)), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Data sent: \u00a7f" + TunnelCommands.formatBytes(status.bytesSent))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Data received: \u00a7f" + TunnelCommands.formatBytes(status.bytesReceived))), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int openGui(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_230896_() == null) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cThis command must be run by a player."));
            return 0;
        }
        try {
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new TunnelStatusScreen(Minecraft.m_91087_().f_91080_)));
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to open GUI: " + e.getMessage())));
            return 0;
        }
    }

    private static int openAdvancedGui(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_230896_() == null) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cThis command must be run by a player."));
            return 0;
        }
        try {
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)new AdvancedStatusScreen(Minecraft.m_91087_().f_91080_)));
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to open GUI: " + e.getMessage())));
            return 0;
        }
    }

    private static int runDiagnostics(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lRunning network diagnostics..."), false);
        NetworkDiagnostics.DiagnosticReport report = NetworkDiagnostics.runDiagnostics();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550 Network Diagnostics \u2550\u2550\u2550"), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Local IPv4: \u00a7f" + report.localIP)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Public IPv4: \u00a7f" + (report.publicIP != null ? report.publicIP : "Unknown"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Local IPv6: \u00a7f" + (report.localIPv6 != null ? report.localIPv6 : "Not available"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Public IPv6: \u00a7f" + (report.publicIPv6 != null ? report.publicIPv6 : "Not available"))), false);
        if (report.hasPublicIPv6) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u26a1 IPv6 Available - NAT bypass possible!"), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Internet (IPv4): " + (report.hasInternet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Internet (IPv6): " + (report.hasIPv6Internet ? "\u00a7a\u2713 Connected" : "\u00a7c\u2717 No connection"))), false);
        if (report.behindNAT) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77NAT: \u00a7e\u26a0 Behind NAT (" + report.natType.getDescription() + ")")), false);
            if (report.stunOk && report.mappedPublicIP != null) {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a78\u2022 STUN mapping: \u00a77" + report.mappedPublicIP + ":" + report.mappedPublicPort)), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a78\u2022 Port-preserving: \u00a77" + (report.stunPortPreserving ? "Yes" : "No") + " \u00a78\u2502 Varies across servers: \u00a77" + (report.stunMappingVaries ? "Yes" : "No"))), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a78\u2022 STUN reachability: \u00a77" + report.stunSuccessful + "/" + report.stunTotal + " (" + (int)(report.stunReliability * 100.0) + "%)")), false);
                if (report.stunMappings != null && !report.stunMappings.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    int show = Math.min(report.stunMappings.size(), 3);
                    for (int i = 0; i < show; ++i) {
                        sb.append(report.stunMappings.get(i).toString());
                        if (i + 1 >= show) continue;
                        sb.append(", ");
                    }
                    if (report.stunMappings.size() > show) {
                        sb.append(" \u2026+").append(report.stunMappings.size() - show).append(" more");
                    }
                    String mappingsStr = sb.toString();
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a78\u2022 STUN mappings: \u00a77" + mappingsStr)), false);
                }
                if (report.natReason != null && !report.natReason.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a78\u2022 Reason: \u00a77" + report.natReason)), false);
                }
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a78\u2022 STUN: \u00a77No response from servers (UDP may be blocked)"), false);
            }
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77NAT: \u00a7a\u2713 Direct"), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77UPnP: " + (report.upnpAvailable ? "\u00a7a\u2713 Available" : "\u00a7c\u2717 Not available"))), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Firewall: " + (report.firewallDetected ? "\u00a7e\u26a0 Detected" : "\u00a7a\u2713 None detected"))), false);
        if (!report.availablePorts.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Available ports: \u00a7f" + String.valueOf(report.availablePorts))), false);
        }
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Recommendation:"), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77" + report.getRecommendation())), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int showHelp(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l      Tunnely P2P - Commands"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lServer Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel create \u00a78[maxPeers] [ttl] [mcPort]"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Create a P2P tunnel server"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a78\u2022 \u00a77maxPeers: Max players (default: 4)"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a78\u2022 \u00a77ttl: Session duration in seconds (default: 3600)"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a78\u2022 \u00a77mcPort: Minecraft port (default: auto-detect)"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel token"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Display your connection token"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel invite"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Copy connection token to clipboard"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lClient Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel connect \u00a78<token>"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Connect to a host using their token"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel connect paste"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Connect using token from clipboard"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lGeneral Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel stop"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Stop current tunnel session"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel status"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Show current tunnel status"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel diagnostics"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Run network diagnostics"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lGUI Commands:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel gui"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Open status screen"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel advanced"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Open advanced status screen"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e\u00a7lConfiguration:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel config reload"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Reload configuration"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77/tunnel config reset"), false);
        source.m_288197_(() -> Component.m_237113_((String)"  \u00a77Reset config to defaults"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7lTip:"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77Press \u00a7e[U] \u00a77to open the Tunnely Management Screen"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a77for easy access to all features!"), false);
        source.m_288197_(() -> Component.m_237113_((String)""), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550"), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            TunnelConfig.getInstance().save();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Configuration reloaded"), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to reload config: " + e.getMessage())));
            return 0;
        }
    }

    private static int resetConfig(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        try {
            TunnelConfig.getInstance().resetToDefaults();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Configuration reset to defaults"), false);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to reset config: " + e.getMessage())));
            return 0;
        }
    }

    private static String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        return seconds / 3600L + "h";
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.1f GB", (double)bytes / 1.073741824E9);
    }

    private static int findFreeTcpPort() {
        int n;
        ServerSocket ss = new ServerSocket(0);
        try {
            ss.setReuseAddress(true);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return 0;
            }
        }
        ss.close();
        return n;
    }

    private static boolean shouldShowTokenInChat() {
        try {
            Class.forName("dev.architectury.platform.Platform");
            TunnelConfig config = TunnelConfig.getInstance();
            return config.showTokenInChat || config.debug;
        }
        catch (Throwable e) {
            return true;
        }
    }

    private static /* synthetic */ Component lambda$showToken$23(Component tokenComponent) {
        return tokenComponent;
    }

    private static /* synthetic */ Component lambda$createTunnel$17(Component tokenComponent) {
        return tokenComponent;
    }
}

