/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.connection;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.texboobcat.tunnelyP2p.config.TunnelConfig;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.crypto.CryptoManager;
import org.texboobcat.tunnelyP2p.crypto.KeyPairHolder;
import org.texboobcat.tunnelyP2p.crypto.SessionKeys;
import org.texboobcat.tunnelyP2p.nat.NATTraversal;
import org.texboobcat.tunnelyP2p.protocol.AuthChallengeMessage;
import org.texboobcat.tunnelyP2p.protocol.AuthResponseMessage;
import org.texboobcat.tunnelyP2p.protocol.ErrorMessage;
import org.texboobcat.tunnelyP2p.protocol.HandshakeMessage;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamAckMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamCloseMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamDataMessage;
import org.texboobcat.tunnelyP2p.token.ConnectionToken;
import org.texboobcat.tunnelyP2p.token.TokenCodec;
import org.texboobcat.tunnelyP2p.util.Log;

public class TunnelServer
implements AutoCloseable {
    private final int bindPort;
    private final String minecraftServerHost;
    private final int minecraftServerPort;
    private final int maxPeers;
    private final KeyPairHolder hostKeyPair;
    private final UUID sessionId;
    private final long ttlSeconds;
    private final String publicIP;
    private final int mappedPort;
    private final String localIP;
    private final String publicIPv6;
    private final String localIPv6;
    private final boolean upnpSuccess;
    private volatile ConnectionToken cachedToken;
    private ServerSocket serverSocket;
    private final Map<UUID, PeerConnection> connectedPeers = new ConcurrentHashMap<UUID, PeerConnection>();
    private final Map<Integer, MinecraftForwarder> forwarders = new ConcurrentHashMap<Integer, MinecraftForwarder>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final NATTraversal natTraversal = new NATTraversal();
    private Thread shutdownHook;
    private int nextConnectionId = 1;

    public TunnelServer(int bindPort, String minecraftServerHost, int minecraftServerPort, int maxPeers, long ttlSeconds) throws GeneralSecurityException, UnknownHostException {
        this.bindPort = bindPort;
        this.minecraftServerHost = minecraftServerHost;
        this.minecraftServerPort = minecraftServerPort;
        this.maxPeers = maxPeers;
        this.ttlSeconds = ttlSeconds;
        this.sessionId = UUID.randomUUID();
        this.hostKeyPair = CryptoManager.generateKeyPair();
        Log.d("[TunnelServer] Attempting UPnP port mapping...");
        this.mappedPort = this.natTraversal.openPortUPnP(bindPort, 0, "TunnelyP2P Tunnel");
        this.upnpSuccess = this.mappedPort > 0;
        this.publicIP = NATTraversal.getPublicIP();
        if (this.publicIP != null) {
            Log.d("[TunnelServer] Detected public IPv4: " + this.publicIP);
        }
        this.localIP = NATTraversal.getLocalIP();
        Log.d("[TunnelServer] Local IPv4: " + this.localIP);
        this.localIPv6 = NATTraversal.getLocalIPv6();
        if (this.localIPv6 != null) {
            Log.d("[TunnelServer] Detected local IPv6: " + this.localIPv6);
        }
        this.publicIPv6 = NATTraversal.getPublicIPv6();
        if (this.publicIPv6 != null) {
            Log.d("[TunnelServer] Detected public IPv6: " + this.publicIPv6 + " (NAT bypass available!)");
        }
        this.cachedToken = null;
    }

    public void start() throws IOException {
        if (this.running.compareAndSet(false, true)) {
            this.serverSocket = new ServerSocket(this.bindPort);
            this.executor.submit(this::acceptLoop);
            this.shutdownHook = new Thread(() -> {
                Log.d("[TunnelServer] Shutdown hook triggered - cleaning up resources");
                try {
                    this.natTraversal.closePort();
                }
                catch (Exception e) {
                    Log.e("[TunnelServer] Error during shutdown hook cleanup: " + e.getMessage());
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public String getConnectionToken() {
        ConnectionToken token = this.getOrCreateToken();
        try {
            TunnelConfig config = TunnelConfig.getInstance();
            if (!config.includeLocalIPInToken && !config.debug) {
                ConnectionToken.NATInfo filteredNatInfo = new ConnectionToken.NATInfo(token.getNatInfo().getPublicIP(), token.getNatInfo().getPublicPort(), null, null, token.getNatInfo().getPublicIPv6(), token.getNatInfo().getPublicPortv6(), null, null, token.getNatInfo().isUpnpSuccess(), token.getNatInfo().getUdpPorts());
                ConnectionToken filteredToken = new ConnectionToken(token.getSessionId(), token.getHostPublicKey(), filteredNatInfo, token.getTimestamp(), token.getTtlSeconds(), token.getHostPlayerUUID(), token.getHostPlayerName(), token.getSignature());
                return TokenCodec.encode(filteredToken);
            }
        }
        catch (Throwable e) {
            Log.d("[TunnelServer] Privacy filtering unavailable, using full token: " + e.getMessage());
        }
        return TokenCodec.encode(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionToken getOrCreateToken() {
        if (this.cachedToken == null) {
            TunnelServer tunnelServer = this;
            synchronized (tunnelServer) {
                if (this.cachedToken == null) {
                    ConnectionToken.NATInfo natInfo = new ConnectionToken.NATInfo(this.publicIP, this.upnpSuccess ? this.mappedPort : this.bindPort, this.localIP, this.bindPort, this.publicIPv6, this.bindPort, this.localIPv6, this.bindPort, this.upnpSuccess, new ArrayList<Integer>());
                    this.cachedToken = new ConnectionToken(this.sessionId, this.hostKeyPair.getPublicKeyBytes(), natInfo, System.currentTimeMillis() / 1000L, this.ttlSeconds, UUID.randomUUID(), "HostPlayer", null);
                    Log.d("[TunnelServer] Token generated lazily");
                    if (this.publicIPv6 != null) {
                        Log.d("[TunnelServer] Token includes IPv6 - NAT traversal not needed!");
                    }
                }
            }
        }
        return this.cachedToken;
    }

    private void acceptLoop() {
        block4: {
            try {
                while (this.running.get() && !this.serverSocket.isClosed()) {
                    Socket clientSocket = this.serverSocket.accept();
                    if (this.connectedPeers.size() >= this.maxPeers) {
                        clientSocket.close();
                        continue;
                    }
                    this.executor.submit(() -> this.handleNewConnection(clientSocket));
                }
            }
            catch (IOException e) {
                if (!this.running.get()) break block4;
                e.printStackTrace();
            }
        }
    }

    private void handleNewConnection(Socket socket) {
        try {
            AuthResponseMessage authResponse;
            SessionKeys sessionKeys;
            block16: {
                byte[] data;
                int length;
                DataInputStream input = new DataInputStream(socket.getInputStream());
                DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                try {
                    length = input.readInt();
                    data = new byte[length];
                    input.readFully(data);
                }
                catch (EOFException eof) {
                    socket.close();
                    return;
                }
                ProtocolMessage msg = ProtocolMessage.deserialize(data);
                if (!(msg instanceof HandshakeMessage)) {
                    socket.close();
                    return;
                }
                HandshakeMessage handshake = (HandshakeMessage)msg;
                if (!handshake.getSessionId().equals(this.sessionId)) {
                    this.sendError(output, 1, "Invalid session ID");
                    socket.close();
                    return;
                }
                ConnectionToken token = this.getOrCreateToken();
                String tokenStr = TokenCodec.encodeCanonical(token);
                byte[] tokenHash = MessageDigest.getInstance("SHA-256").digest(tokenStr.getBytes());
                if (!MessageDigest.isEqual(handshake.getTokenHash(), tokenHash)) {
                    this.sendError(output, 2, "Invalid token");
                    socket.close();
                    return;
                }
                byte[] nonce = CryptoManager.generateNonce();
                byte[] sharedSecret = CryptoManager.performECDH(this.hostKeyPair.getPrivateKey().getEncoded(), handshake.getClientPublicKey());
                byte[] info = "TunnelyP2P-Session".getBytes();
                sessionKeys = CryptoManager.deriveSessionKeys(sharedSecret, nonce, info);
                AuthChallengeMessage challenge = new AuthChallengeMessage(nonce);
                this.sendMessage(output, challenge);
                try {
                    length = input.readInt();
                    data = new byte[length];
                    input.readFully(data);
                }
                catch (EOFException eof) {
                    socket.close();
                    return;
                }
                msg = ProtocolMessage.deserialize(data);
                if (!(msg instanceof AuthResponseMessage)) {
                    socket.close();
                    return;
                }
                authResponse = (AuthResponseMessage)msg;
                try {
                    byte[] decryptedNonce = CryptoManager.decryptChaCha20Poly1305(sessionKeys.getRawEncryptionKey(), authResponse.getEncryptionNonce(), authResponse.getSignedNonce(), null);
                    if (MessageDigest.isEqual(decryptedNonce, nonce)) break block16;
                    this.sendError(output, 4, "Auth failed: challenge mismatch");
                    socket.close();
                    try {
                        Thread.sleep(100 + new SecureRandom().nextInt(100));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                catch (GeneralSecurityException e) {
                    this.sendError(output, 3, "Invalid authentication");
                    socket.close();
                    return;
                }
            }
            UUID peerUUID = authResponse.getPlayerUUID();
            String peerName = authResponse.getPlayerName();
            PeerConnection peerConn = new PeerConnection(socket, sessionKeys, this.sessionId, peerUUID, peerName);
            this.connectedPeers.put(peerUUID, peerConn);
            peerConn.setMessageHandler(message -> this.handlePeerMessage(peerConn, (ProtocolMessage)message));
            peerConn.setErrorHandler(error -> {
                Log.e("[TunnelServer] Peer connection error: " + error.getMessage(), error);
                this.removePeer(peerUUID);
            });
            Log.d("Peer connected: " + peerName + " (" + String.valueOf(peerUUID) + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handlePeerMessage(PeerConnection peer, ProtocolMessage message) {
        try {
            StreamCloseMessage closeMsg;
            MinecraftForwarder forwarder;
            if (message instanceof StreamDataMessage) {
                StreamDataMessage dataMsg = (StreamDataMessage)message;
                byte[] decrypted = CryptoManager.decryptChaCha20Poly1305(peer.getSessionKeys().getRawEncryptionKey(), dataMsg.getNonce(), dataMsg.getEncryptedPayload(), null);
                MinecraftForwarder forwarder2 = this.forwarders.computeIfAbsent(dataMsg.getConnectionId(), id -> new MinecraftForwarder((int)id, peer, this.minecraftServerHost, this.minecraftServerPort));
                forwarder2.sendToMinecraft(decrypted);
                peer.sendMessage(new StreamAckMessage(dataMsg.getConnectionId(), dataMsg.getSequenceNumber()));
            } else if (message instanceof StreamCloseMessage && (forwarder = this.forwarders.remove((closeMsg = (StreamCloseMessage)message).getConnectionId())) != null) {
                forwarder.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removePeer(UUID peerUUID) {
        PeerConnection peer = this.connectedPeers.remove(peerUUID);
        if (peer != null) {
            peer.close();
            Log.d("Peer disconnected: " + peer.getPeerName());
        }
    }

    private void sendMessage(DataOutputStream output, ProtocolMessage message) throws IOException {
        byte[] data = message.serialize();
        output.writeInt(data.length);
        output.write(data);
        output.flush();
    }

    private void sendError(DataOutputStream output, int code, String msg) throws IOException {
        this.sendMessage(output, new ErrorMessage(code, msg));
    }

    public NATTraversal getNatTraversal() {
        return this.natTraversal;
    }

    public Collection<PeerConnection> getConnectedPeers() {
        return Collections.unmodifiableCollection(this.connectedPeers.values());
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            try {
                if (this.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
                this.connectedPeers.values().forEach(PeerConnection::close);
                this.connectedPeers.clear();
                this.forwarders.values().forEach(MinecraftForwarder::close);
                this.forwarders.clear();
                this.executor.shutdown();
                this.natTraversal.closePort();
                this.hostKeyPair.clear();
            }
            catch (IOException e) {
                Log.e("[TunnelServer] Error during close: " + e.getMessage());
            }
        }
    }

    private class MinecraftForwarder
    implements AutoCloseable {
        private final int connectionId;
        private final PeerConnection peer;
        private Socket minecraftSocket;
        private DataOutputStream minecraftOutput;
        private final ExecutorService forwardExecutor = Executors.newSingleThreadExecutor();
        private final ExecutorService writeExecutor = Executors.newSingleThreadExecutor();
        private final BlockingQueue<byte[]> writeQueue = new LinkedBlockingQueue<byte[]>();

        public MinecraftForwarder(int connectionId, PeerConnection peer, String host, int port) {
            this.connectionId = connectionId;
            this.peer = peer;
            try {
                Log.d("[Forwarder] Connecting to local Minecraft server at " + host + ":" + port + " (connId=" + connectionId + ")");
                this.minecraftSocket = new Socket(host, port);
                try {
                    this.minecraftSocket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.minecraftOutput = new DataOutputStream(this.minecraftSocket.getOutputStream());
                Log.d("[Forwarder] Connected to local Minecraft server (connId=" + connectionId + ")");
                this.forwardExecutor.submit(this::readFromMinecraft);
                this.writeExecutor.submit(this::writeToMinecraftLoop);
            }
            catch (IOException e) {
                Log.e("[Forwarder] Failed to connect to local Minecraft server: " + e.getMessage(), e);
                this.close();
            }
        }

        public void sendToMinecraft(byte[] data) throws IOException {
            this.writeQueue.offer(data);
        }

        private void writeToMinecraftLoop() {
            try {
                while (!this.minecraftSocket.isClosed()) {
                    byte[] chunk = this.writeQueue.take();
                    if (this.minecraftOutput == null) continue;
                    this.minecraftOutput.write(chunk);
                    this.minecraftOutput.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFromMinecraft() {
            try {
                int bytesRead;
                InputStream input = this.minecraftSocket.getInputStream();
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    byte[] data = Arrays.copyOf(buffer, bytesRead);
                    this.peer.sendStreamData(this.connectionId, data);
                }
            }
            catch (Exception e) {
                Log.e("[Forwarder] Read from Minecraft failed/closed: " + e.getMessage());
            }
            finally {
                try {
                    this.peer.sendMessage(new StreamCloseMessage(this.connectionId, "Minecraft server closed connection"));
                }
                catch (IOException iOException) {}
                this.close();
            }
        }

        @Override
        public void close() {
            try {
                this.forwardExecutor.shutdown();
                this.writeExecutor.shutdown();
                if (this.minecraftSocket != null) {
                    this.minecraftSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

