/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.i18n.I18n;

public class AdvancedStatusScreen
extends Screen {
    private final Screen parent;
    private Button closeButton;
    private Button stopButton;
    private Button basicViewButton;
    private Button alternativeModButton;
    private int currentTab = 0;

    public AdvancedStatusScreen(Screen parent) {
        super((Component)Component.m_237113_((String)I18n.t("gui.tunnel.title", new Object[0])));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int startX = this.f_96543_ / 2 - (buttonWidth * 3 + buttonSpacing * 2) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Overview"), button -> {
            this.currentTab = 0;
        }).m_252987_(startX, 35, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Metrics"), button -> {
            this.currentTab = 1;
        }).m_252987_(startX + buttonWidth + buttonSpacing, 35, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Advanced"), button -> {
            this.currentTab = 2;
        }).m_252987_(startX + (buttonWidth + buttonSpacing) * 2, 35, buttonWidth, buttonHeight).m_253136_());
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)I18n.t("gui.tunnel.close", new Object[0])), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - buttonWidth - buttonSpacing, this.f_96544_ - 40, buttonWidth, buttonHeight).m_253136_();
        this.stopButton = Button.m_253074_((Component)Component.m_237113_((String)I18n.t("gui.tunnel.stop", new Object[0])), button -> {
            TunnelManager.getInstance().stopAll();
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.f_96543_ / 2 + buttonSpacing, this.f_96544_ - 40, buttonWidth, buttonHeight).m_253136_();
        this.alternativeModButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76Tunnely"), button -> this.showAlternativeModInfo()).m_252987_(this.f_96543_ - 110, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.alternativeModButton);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (status.active) {
            this.m_142416_((GuiEventListener)this.stopButton);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        graphics.m_280137_(this.f_96547_, "\u00a7b\u00a7lTunnely P2P - Advanced Status", this.f_96543_ / 2, 15, 0xFFFFFF);
        switch (this.currentTab) {
            case 0: {
                this.renderOverview(graphics, status);
                break;
            }
            case 1: {
                this.renderMetrics(graphics, status);
                break;
            }
            case 2: {
                this.renderAdvanced(graphics, status);
            }
        }
    }

    private void renderOverview(GuiGraphics graphics, TunnelManager.SessionStatus status) {
        int centerX = this.f_96543_ / 2;
        int startY = 70;
        int lineHeight = 12;
        if (!status.active) {
            graphics.m_280137_(this.f_96547_, "\u00a77Status: \u00a7cInactive", centerX, startY, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, I18n.t("gui.tunnel.noactive", new Object[0]), centerX, startY + lineHeight * 2, 0xAAAAAA);
            return;
        }
        if ("host".equals(status.mode)) {
            graphics.m_280137_(this.f_96547_, "\u00a77Mode: \u00a7aHost \u00a77\u2502 \u00a77Peers: \u00a7f" + status.peerCount, centerX, startY, 0xFFFFFF);
            int y = startY + lineHeight * 2;
            if (status.peerCount > 0) {
                graphics.m_280137_(this.f_96547_, "\u00a76Connected Players:", centerX, y, 0xFFFFFF);
                y += lineHeight * 2;
                for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                    String peerInfo = String.format("\u00a7f%s \u00a78\u2502 \u00a77\u2191%s \u00a77\u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                    graphics.m_280137_(this.f_96547_, peerInfo, centerX, y, 0xFFFFFF);
                    y += lineHeight;
                }
            } else {
                graphics.m_280137_(this.f_96547_, "\u00a77Waiting for connections...", centerX, y, 0xAAAAAA);
            }
        } else if ("client".equals(status.mode)) {
            graphics.m_280137_(this.f_96547_, "\u00a77Mode: \u00a7aClient \u00a77\u2502 \u00a77Host: \u00a7f" + status.hostName, centerX, startY, 0xFFFFFF);
            int y = startY + lineHeight * 2;
            graphics.m_280137_(this.f_96547_, "\u00a77Proxy Address: \u00a7f127.0.0.1:" + status.localPort, centerX, y, 0xFFFFFF);
            long totalBytes = status.bytesSent + status.bytesReceived;
            String quality = this.getQualityIndicator(totalBytes);
            graphics.m_280137_(this.f_96547_, "\u00a77Connection: " + quality, centerX, y += lineHeight, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "\u00a77Uploaded: \u00a7f" + this.formatBytes(status.bytesSent), centerX, y += lineHeight * 2, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "\u00a77Downloaded: \u00a7f" + this.formatBytes(status.bytesReceived), centerX, y += lineHeight, 0xFFFFFF);
        }
    }

    private void renderMetrics(GuiGraphics graphics, TunnelManager.SessionStatus status) {
        int leftX = this.f_96543_ / 4;
        int rightX = this.f_96543_ * 3 / 4;
        int startY = 70;
        int lineHeight = 12;
        if (!status.active) {
            graphics.m_280137_(this.f_96547_, "\u00a77No active session", this.f_96543_ / 2, startY + lineHeight * 3, 0xAAAAAA);
            return;
        }
        int y = startY;
        graphics.m_280488_(this.f_96547_, "\u00a7e\u00a7lTraffic Statistics", leftX - 60, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77Sent:", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7f" + this.formatBytes(status.bytesSent), leftX + 10, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77Received:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7f" + this.formatBytes(status.bytesReceived), leftX + 10, y, 0xFFFFFF);
        long total = status.bytesSent + status.bytesReceived;
        graphics.m_280488_(this.f_96547_, "\u00a77Total:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7f" + this.formatBytes(total), leftX + 10, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7e\u00a7lConnection Info", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77Protocol:", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7fTCP/Encrypted", leftX + 10, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77Encryption:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7aChaCha20-Poly1305", leftX + 10, y, 0xFFFFFF);
        y = startY;
        graphics.m_280488_(this.f_96547_, "\u00a7e\u00a7lPerformance", rightX - 60, y, 0xFFFFFF);
        y += lineHeight * 2;
        if ("client".equals(status.mode)) {
            PeerConnection peer;
            PeerConnection peerConnection = peer = TunnelManager.getInstance().getActiveProxy() != null ? TunnelManager.getInstance().getActiveProxy().getPeerConnection() : null;
            if (peer != null) {
                long latency = peer.getLatency();
                graphics.m_280488_(this.f_96547_, "\u00a77Latency:", rightX - 60, y, 0xFFFFFF);
                graphics.m_280488_(this.f_96547_, this.getLatencyColor(latency) + latency + "ms", rightX + 10, y, 0xFFFFFF);
                y += lineHeight;
            }
        }
        String qualityText = "\u00a7aExcellent";
        if (total < 102400L) {
            qualityText = "\u00a77Starting...";
        } else if (total > 0x6400000L) {
            qualityText = "\u00a76Heavy";
        }
        graphics.m_280488_(this.f_96547_, "\u00a77Quality:", rightX - 60, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, qualityText, rightX + 10, y, 0xFFFFFF);
    }

    private void renderAdvanced(GuiGraphics graphics, TunnelManager.SessionStatus status) {
        int centerX = this.f_96543_ / 2;
        int startY = 70;
        int lineHeight = 12;
        int y = startY;
        graphics.m_280137_(this.f_96547_, "\u00a7e\u00a7lAdvanced Information", centerX, y, 0xFFFFFF);
        y += lineHeight * 2;
        if (!status.active) {
            graphics.m_280137_(this.f_96547_, "\u00a77No active session", centerX, y + lineHeight * 2, 0xAAAAAA);
            return;
        }
        graphics.m_280137_(this.f_96547_, "\u00a77Session Mode: \u00a7f" + ("host".equals(status.mode) ? "Server (Hosting)" : "Client (Connected)"), centerX, y, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Key Exchange: \u00a7fX25519 ECDH", centerX, y += lineHeight, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Cipher: \u00a7fChaCha20-Poly1305 (AEAD)", centerX, y += lineHeight, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Key Derivation: \u00a7fHKDF-SHA256", centerX, y += lineHeight, 0xFFFFFF);
        y += lineHeight * 2;
        if ("host".equals(status.mode)) {
            graphics.m_280137_(this.f_96547_, "\u00a77Max Peers: \u00a7f4 \u00a78\u2502 \u00a77NAT: \u00a7fUPnP", centerX, y, 0xFFFFFF);
        } else {
            graphics.m_280137_(this.f_96547_, "\u00a77Connection Strategy: \u00a7fDirect TCP", centerX, y, 0xFFFFFF);
        }
        graphics.m_280137_(this.f_96547_, "\u00a7a\u2713 \u00a77End-to-end encrypted", centerX, y += lineHeight * 2, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a7a\u2713 \u00a77Authenticated session", centerX, y += lineHeight, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a7a\u2713 \u00a77Forward secrecy", centerX, y += lineHeight, 0xFFFFFF);
    }

    private String getQualityIndicator(long totalBytes) {
        if (totalBytes < 10240L) {
            return "\u00a77Starting...";
        }
        if (totalBytes > 0x3200000L) {
            return "\u00a7aExcellent";
        }
        if (totalBytes > 0xA00000L) {
            return "\u00a72Good";
        }
        return "\u00a7eActive";
    }

    private String getLatencyColor(long latency) {
        if (latency < 50L) {
            return "\u00a7a";
        }
        if (latency < 100L) {
            return "\u00a72";
        }
        if (latency < 200L) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void showAlternativeModInfo() {
        String downloadUrl = "https://modrinth.com/mod/tunnely";
        MutableComponent title = Component.m_237113_((String)"\u00a76\u00a7lTunnely - Alternative Version");
        String message = "\u00a77Tunnely is designed for modpacks and public servers:\n\n\u00a7a\u2713 Public Server Browser \u00a77with mod compatibility checks\n\u00a7a\u2713 Mesh-Relay System \u00a77for improved ping and stability\n\u00a7a\u2713 Database-backed \u00a77connection management\n\u00a7a\u2713 Better for large communities \u00a77and modpack integration\n\n\u00a7eThis P2P version \u00a77is better for private, direct connections.\n\u00a7eThe standard version \u00a77is better for public servers and modpacks.";
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                try {
                    Desktop.getDesktop().browse(URI.create(downloadUrl));
                }
                catch (Exception e) {
                    try {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + downloadUrl);
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec("open " + downloadUrl);
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec("xdg-open " + downloadUrl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)title, message, (Component)Component.m_237113_((String)"Back"), true));
    }
}

