/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;

public class TunnelStatusScreen
extends Screen {
    private final Screen parent;
    private Button closeButton;
    private Button stopButton;
    private Button alternativeModButton;

    public TunnelStatusScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Tunnel Status"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - buttonWidth - buttonSpacing, this.f_96544_ - 40, buttonWidth, buttonHeight).m_253136_();
        this.stopButton = Button.m_253074_((Component)Component.m_237113_((String)"Stop Session"), button -> {
            TunnelManager.getInstance().stopAll();
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.f_96543_ / 2 + buttonSpacing, this.f_96544_ - 40, buttonWidth, buttonHeight).m_253136_();
        this.alternativeModButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76Tunnely"), button -> this.showAlternativeModInfo()).m_252987_(this.f_96543_ - 110, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.m_142416_((GuiEventListener)this.alternativeModButton);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (status.active) {
            this.m_142416_((GuiEventListener)this.stopButton);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        int centerX = this.f_96543_ / 2;
        int startY = 40;
        int lineHeight = 12;
        graphics.m_280137_(this.f_96547_, "\u00a7b\u00a7lTunnel Status", centerX, 20, 0xFFFFFF);
        if (!status.active) {
            graphics.m_280137_(this.f_96547_, "\u00a77Status: \u00a7cInactive", centerX, startY, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "\u00a77No active tunnel session", centerX, startY + lineHeight * 2, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77Use \u00a7f/tunnel create \u00a77to host", centerX, startY + lineHeight * 3, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77Use \u00a7f/tunnel connect <token> \u00a77to join", centerX, startY + lineHeight * 4, 0xAAAAAA);
        } else if ("host".equals(status.mode)) {
            this.renderHostStatus(graphics, status, centerX, startY, lineHeight);
        } else if ("client".equals(status.mode)) {
            this.renderClientStatus(graphics, status, centerX, startY, lineHeight);
        }
    }

    private void renderHostStatus(GuiGraphics graphics, TunnelManager.SessionStatus status, int centerX, int startY, int lineHeight) {
        graphics.m_280137_(this.f_96547_, "\u00a77Mode: \u00a7aHost", centerX, startY, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Connected Peers: \u00a7f" + status.peerCount, centerX, startY + lineHeight, 0xFFFFFF);
        int y = startY + lineHeight * 3;
        if (status.peerCount > 0) {
            graphics.m_280137_(this.f_96547_, "\u00a77Connected Players:", centerX, y, 0xFFFFFF);
            y += lineHeight * 2;
            for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                String peerInfo = String.format("\u00a7f%s \u00a77- \u2191%s \u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                graphics.m_280137_(this.f_96547_, peerInfo, centerX, y, 0xFFFFFF);
                y += lineHeight;
            }
        } else {
            graphics.m_280137_(this.f_96547_, "\u00a77No peers connected yet", centerX, y, 0xAAAAAA);
            graphics.m_280137_(this.f_96547_, "\u00a77Use \u00a7f/tunnel token \u00a77to get the connection token", centerX, y += lineHeight * 2, 0xAAAAAA);
        }
    }

    private void renderClientStatus(GuiGraphics graphics, TunnelManager.SessionStatus status, int centerX, int startY, int lineHeight) {
        graphics.m_280137_(this.f_96547_, "\u00a77Mode: \u00a7aClient", centerX, startY, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Connected to: \u00a7f" + status.hostName, centerX, startY + lineHeight, 0xFFFFFF);
        int y = startY + lineHeight * 3;
        graphics.m_280137_(this.f_96547_, "\u00a77Local Proxy: \u00a7flocalhost:" + status.localPort, centerX, y, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Data Sent: \u00a7f" + this.formatBytes(status.bytesSent), centerX, y += lineHeight, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Data Received: \u00a7f" + this.formatBytes(status.bytesReceived), centerX, y += lineHeight, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a7aAdd server: \u00a7f127.0.0.1:" + status.localPort, centerX, y += lineHeight * 2, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Connect to join the host's server", centerX, y += lineHeight, 0xAAAAAA);
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void showAlternativeModInfo() {
        String downloadUrl = "https://modrinth.com/mod/tunnely";
        MutableComponent title = Component.m_237113_((String)"\u00a76\u00a7lTunnely - Alternative Version");
        String message = "\u00a77Tunnely is designed for modpacks and public servers:\n\n\u00a7a\u2713 Public Server Browser \u00a77with mod compatibility checks\n\u00a7a\u2713 Mesh-Relay System \u00a77for improved ping and stability\n\u00a7a\u2713 Database-backed \u00a77connection management\n\u00a7a\u2713 Better for large communities \u00a77and modpack integration\n\n\u00a7eThis P2P version \u00a77is better for private, direct connections.\n\u00a7eThe standard version \u00a77is better for public servers and modpacks.";
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                try {
                    Desktop.getDesktop().browse(URI.create(downloadUrl));
                }
                catch (Exception e) {
                    try {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + downloadUrl);
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec("open " + downloadUrl);
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec("xdg-open " + downloadUrl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)title, message, (Component)Component.m_237113_((String)"Back"), true));
    }
}

