/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Desktop;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.texboobcat.tunnelyP2p.TunnelManager;

public class TunnelyJoinScreen
extends Screen {
    private final Screen parent;
    private EditBox tokenBox;
    private String status = "";
    private Button openMpBtn;
    private Button copyAddrBtn;
    private Button alternativeModButton;
    private int localPort = 25999;

    public TunnelyJoinScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Tunnely - Join"));
        this.parent = parent;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int y = this.f_96544_ / 4 + 40;
        this.tokenBox = new EditBox(this.f_96547_, centerX - 150, y, 300, 20, (Component)Component.m_237113_((String)"Enter connection token"));
        this.tokenBox.m_94199_(4096);
        this.tokenBox.m_93692_(true);
        this.m_142416_((GuiEventListener)this.tokenBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Paste"), b -> {
            try {
                String clip = Minecraft.m_91087_().f_91068_.m_90876_();
                if (clip != null) {
                    this.tokenBox.m_94144_(clip.trim());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).m_252987_(centerX - 150, y + 26, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Join"), b -> this.doJoin()).m_252987_(centerX - 84, y + 26, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX + 6, y + 26, 60, 20).m_253136_());
        this.openMpBtn = Button.m_253074_((Component)Component.m_237113_((String)"Open Multiplayer"), b -> this.openMultiplayer()).m_252987_(centerX - 150, y + 52, 140, 20).m_253136_();
        this.openMpBtn.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.openMpBtn);
        this.copyAddrBtn = Button.m_253074_((Component)Component.m_237113_((String)"Copy Address"), b -> this.copyAddress()).m_252987_(centerX + 10, y + 52, 140, 20).m_253136_();
        this.copyAddrBtn.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.copyAddrBtn);
        this.alternativeModButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76Tunnely"), button -> this.showAlternativeModInfo()).m_252987_(this.f_96543_ - 110, 10, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.alternativeModButton);
    }

    private void doJoin() {
        String token = this.tokenBox.m_94155_();
        if (token == null || token.trim().isEmpty()) {
            this.status = "\u00a7cPlease enter a token";
            return;
        }
        token = token.trim();
        String name = "Player";
        UUID uuid = null;
        try {
            User user = Minecraft.m_91087_().m_91094_();
            if (user != null) {
                name = user.m_92546_();
                String uuidStr = user.m_92545_();
                try {
                    uuid = uuidStr != null && !uuidStr.isEmpty() ? UUID.fromString(uuidStr) : null;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Throwable user) {
            // empty catch block
        }
        if (uuid == null) {
            uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8));
        }
        this.status = "\u00a7eConnecting...";
        String tokenFinal = token;
        String playerName = name;
        UUID playerUuid = uuid;
        Minecraft.m_91087_().execute(() -> {
            try {
                TunnelManager.getInstance().connectToHost(tokenFinal, this.localPort, playerUuid, playerName);
                this.status = "\u00a7aConnected! Use 127.0.0.1:" + this.localPort + " in Multiplayer.";
                if (this.openMpBtn != null) {
                    this.openMpBtn.f_93623_ = true;
                }
                if (this.copyAddrBtn != null) {
                    this.copyAddrBtn.f_93623_ = true;
                }
                this.copyAddress();
                Minecraft mc = Minecraft.m_91087_();
                ServerAddress addr = ServerAddress.m_171864_((String)("127.0.0.1:" + this.localPort));
                ServerData data = new ServerData("Tunnely P2P", "127.0.0.1:" + this.localPort, false);
                ConnectScreen.m_278792_((Screen)this, (Minecraft)mc, (ServerAddress)addr, (ServerData)data, (boolean)false);
            }
            catch (Exception e) {
                this.status = "\u00a7cFailed: " + e.getMessage();
            }
        });
    }

    private void openMultiplayer() {
        Minecraft.m_91087_().m_91152_((Screen)new JoinMultiplayerScreen(this.parent));
    }

    private void copyAddress() {
        try {
            Minecraft.m_91087_().f_91068_.m_90911_("127.0.0.1:" + this.localPort);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void showAlternativeModInfo() {
        String downloadUrl = "https://modrinth.com/mod/tunnely";
        MutableComponent title = Component.m_237113_((String)"\u00a76\u00a7lTunnely - Alternative Version");
        String message = "\u00a77Tunnely is designed for modpacks and public servers:\n\n\u00a7a\u2713 Public Server Browser \u00a77with mod compatibility checks\n\u00a7a\u2713 Mesh-Relay System \u00a77for improved ping and stability\n\u00a7a\u2713 Database-backed \u00a77connection management\n\u00a7a\u2713 Better for large communities \u00a77and modpack integration\n\n\u00a7eThis P2P version \u00a77is better for private, direct connections.\n\u00a7eThe standard version \u00a77is better for public servers and modpacks.";
        this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                try {
                    Desktop.getDesktop().browse(URI.create(downloadUrl));
                }
                catch (Exception e) {
                    try {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + downloadUrl);
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec("open " + downloadUrl);
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec("xdg-open " + downloadUrl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)title, message, (Component)Component.m_237113_((String)"Back"), true));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        Font font = this.f_96547_;
        int centerX = this.f_96543_ / 2;
        graphics.m_280653_(font, this.f_96539_, centerX, this.f_96544_ / 4 + 10, 0xFFFFFF);
        graphics.m_280056_(font, "Token:", centerX - 150, this.f_96544_ / 4 + 28, 0xA0A0A0, false);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.status != null && !this.status.isEmpty()) {
            graphics.m_280653_(font, (Component)Component.m_237113_((String)this.status), centerX, this.f_96544_ / 4 + 60, 0xFFFFFF);
        }
    }
}

