/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.gui.AdvancedStatusScreen;
import org.texboobcat.tunnelyP2p.gui.DiagnosticsScreen;
import org.texboobcat.tunnelyP2p.gui.TunnelStatusScreen;

public class TunnelyManagementScreen
extends Screen {
    private final Screen parent;
    private Button createServerButton;
    private Button connectButton;
    private Button copyTokenButton;
    private Button stopButton;
    private Button diagnosticsButton;
    private Button statusScreenButton;
    private Button advancedScreenButton;
    private Button reloadConfigButton;
    private Button closeButton;
    private EditBox maxPeersInput;
    private EditBox ttlInput;
    private EditBox portInput;
    private int scrollOffset = 0;
    private String statusMessage = "";
    private int statusMessageTimer = 0;
    private boolean statusIsError = false;

    public TunnelyManagementScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Tunnely Management"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int buttonWidth = 150;
        int buttonHeight = 20;
        int inputWidth = 60;
        int spacing = 4;
        int startY = 60;
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (!status.active) {
            this.maxPeersInput = new EditBox(this.f_96547_, centerX - 180, startY, inputWidth, buttonHeight, (Component)Component.m_237113_((String)"Max Peers"));
            this.maxPeersInput.m_94144_("4");
            this.maxPeersInput.m_94199_(2);
            this.m_142416_((GuiEventListener)this.maxPeersInput);
            this.ttlInput = new EditBox(this.f_96547_, centerX - 100, startY, inputWidth, buttonHeight, (Component)Component.m_237113_((String)"TTL"));
            this.ttlInput.m_94144_("3600");
            this.ttlInput.m_94199_(5);
            this.m_142416_((GuiEventListener)this.ttlInput);
            this.portInput = new EditBox(this.f_96547_, centerX - 20, startY, inputWidth, buttonHeight, (Component)Component.m_237113_((String)"MC Port"));
            this.portInput.m_94144_("");
            this.portInput.m_94199_(5);
            this.portInput.m_257771_((Component)Component.m_237113_((String)"Auto"));
            this.m_142416_((GuiEventListener)this.portInput);
            this.createServerButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7aCreate Server"), button -> this.createTunnelServer()).m_252987_(centerX + 60, startY, buttonWidth, buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.createServerButton);
            this.connectButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7bConnect (Paste)"), button -> this.connectFromClipboard()).m_252987_(centerX - buttonWidth / 2, startY += buttonHeight + spacing + 10, buttonWidth, buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.connectButton);
            startY += buttonHeight + spacing + 15;
        } else {
            if ("host".equals(status.mode)) {
                this.copyTokenButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7e\ud83d\udccb Copy Token"), button -> this.copyTokenToClipboard()).m_252987_(centerX - buttonWidth - spacing / 2, startY, buttonWidth, buttonHeight).m_253136_();
                this.m_142416_((GuiEventListener)this.copyTokenButton);
            }
            this.stopButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cStop Session"), button -> this.stopSession()).m_252987_(centerX + spacing / 2, startY, buttonWidth, buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.stopButton);
            startY += buttonHeight + spacing + 15;
        }
        int utilY = startY;
        this.diagnosticsButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a76Run Diagnostics"), button -> this.runDiagnostics()).m_252987_(centerX - buttonWidth - spacing / 2, utilY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.diagnosticsButton);
        this.statusScreenButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7bStatus Screen"), button -> this.openStatusScreen()).m_252987_(centerX + spacing / 2, utilY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.statusScreenButton);
        this.advancedScreenButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a79Advanced Screen"), button -> this.openAdvancedScreen()).m_252987_(centerX - buttonWidth - spacing / 2, utilY += buttonHeight + spacing, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.advancedScreenButton);
        this.reloadConfigButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a77Reload Config"), button -> this.reloadConfig()).m_252987_(centerX + spacing / 2, utilY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.reloadConfigButton);
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()).m_252987_(centerX - 60, this.f_96544_ - 30, 120, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int centerX = this.f_96543_ / 2;
        int lineHeight = 12;
        graphics.m_280137_(this.f_96547_, "\u00a7b\u00a7lTunnely Management", centerX, 15, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Quick access to all tunnel commands", centerX, 28, 0xAAAAAA);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        int statusY = 42;
        if (!status.active) {
            graphics.m_280137_(this.f_96547_, "\u00a77Status: \u00a7cInactive", centerX, statusY, 0xFFFFFF);
        } else if ("host".equals(status.mode)) {
            String statusText = String.format("\u00a77Status: \u00a7aHosting \u00a77\u2502 Peers: \u00a7f%d", status.peerCount);
            graphics.m_280137_(this.f_96547_, statusText, centerX, statusY, 0xFFFFFF);
        } else if ("client".equals(status.mode)) {
            graphics.m_280137_(this.f_96547_, "\u00a77Status: \u00a7aConnected \u00a77\u2502 Host: \u00a7f" + status.hostName, centerX, statusY, 0xFFFFFF);
        }
        if (!status.active) {
            int labelY = 49;
            graphics.m_280488_(this.f_96547_, "\u00a77Max Peers", centerX - 180, labelY, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a77TTL (sec)", centerX - 100, labelY, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, "\u00a77MC Port", centerX - 20, labelY, 0xAAAAAA);
        }
        if (this.statusMessageTimer > 0) {
            int msgColor = this.statusIsError ? 0xFF5555 : 0x55FF55;
            graphics.m_280137_(this.f_96547_, this.statusMessage, centerX, this.f_96544_ - 50, msgColor);
            --this.statusMessageTimer;
        }
        this.renderQuickStatus(graphics, status, centerX, lineHeight);
    }

    private void renderQuickStatus(GuiGraphics graphics, TunnelManager.SessionStatus status, int centerX, int lineHeight) {
        int startY = this.f_96544_ - 85;
        if (!status.active) {
            return;
        }
        graphics.m_280137_(this.f_96547_, "\u00a78\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", centerX, startY, 0x555555);
        startY += lineHeight;
        if ("host".equals(status.mode)) {
            if (status.peerCount > 0) {
                graphics.m_280137_(this.f_96547_, "\u00a77Connected Players:", centerX, startY, 0xFFFFFF);
                startY += lineHeight;
                int count = 0;
                for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                    if (count >= 2) break;
                    String peerInfo = String.format("\u00a7f%s \u00a77\u2191%s \u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                    graphics.m_280137_(this.f_96547_, peerInfo, centerX, startY, 0xFFFFFF);
                    startY += lineHeight;
                    ++count;
                }
                if (status.peerCount > 2) {
                    graphics.m_280137_(this.f_96547_, "\u00a77...and " + (status.peerCount - 2) + " more", centerX, startY, 0xAAAAAA);
                }
            } else {
                graphics.m_280137_(this.f_96547_, "\u00a77No peers connected", centerX, startY, 0xAAAAAA);
            }
        } else if ("client".equals(status.mode)) {
            graphics.m_280137_(this.f_96547_, "\u00a77Proxy: \u00a7flocalhost:" + status.localPort, centerX, startY, 0xFFFFFF);
            graphics.m_280137_(this.f_96547_, "\u00a77\u2191 " + this.formatBytes(status.bytesSent) + " \u00a78\u2502 \u00a77\u2193 " + this.formatBytes(status.bytesReceived), centerX, startY += lineHeight, 0xFFFFFF);
        }
    }

    private void createTunnelServer() {
        try {
            int mcPort;
            int maxPeers = Integer.parseInt(this.maxPeersInput.m_94155_());
            long ttl = Long.parseLong(this.ttlInput.m_94155_());
            int n = mcPort = this.portInput.m_94155_().isEmpty() ? -1 : Integer.parseInt(this.portInput.m_94155_());
            if (maxPeers < 1 || maxPeers > 32) {
                this.showError("Max peers must be between 1-32");
                return;
            }
            if (ttl < 60L || ttl > 86400L) {
                this.showError("TTL must be between 60-86400 seconds");
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.f_108617_ != null) {
                String cmd = mcPort > 0 ? String.format("tunnel create %d %d %d", maxPeers, ttl, mcPort) : String.format("tunnel create %d %d", maxPeers, ttl);
                player.f_108617_.m_246623_(cmd);
                this.showSuccess("Creating tunnel server...");
                Minecraft.m_91087_().execute(() -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.m_7856_();
                });
            }
        }
        catch (NumberFormatException e) {
            this.showError("Invalid input values");
        }
    }

    private void connectFromClipboard() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.f_108617_ == null) {
            this.showError("Must be a player to connect");
            return;
        }
        String token = null;
        try {
            token = mc.f_91068_.m_90876_();
        }
        catch (Throwable ignored) {
            try {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                Object data = cb.getData(DataFlavor.stringFlavor);
                token = data != null ? data.toString() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (token == null || token.trim().isEmpty()) {
            this.showError("Clipboard is empty");
            return;
        }
        mc.f_91074_.f_108617_.m_246623_("tunnel connect " + token.trim());
        this.showSuccess("Connecting to host...");
        mc.execute(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_7856_();
        });
    }

    private void copyTokenToClipboard() {
        TunnelManager manager = TunnelManager.getInstance();
        if (!manager.isHosting()) {
            this.showError("Not hosting a server");
            return;
        }
        String token = manager.getActiveServer().getConnectionToken();
        Minecraft mc = Minecraft.m_91087_();
        try {
            mc.f_91068_.m_90911_(token);
            this.showSuccess("Token copied to clipboard!");
        }
        catch (Throwable mcError) {
            try {
                Clipboard clipboard;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    clipboard.setContents(new StringSelection(token), null);
                    this.showSuccess("Token copied to clipboard!");
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.showError("Failed to copy token");
        }
    }

    private void stopSession() {
        TunnelManager.getInstance().stopAll();
        this.showSuccess("Session stopped");
        Minecraft.m_91087_().execute(this::m_7856_);
    }

    private void runDiagnostics() {
        Minecraft.m_91087_().m_91152_((Screen)new DiagnosticsScreen(this.parent));
    }

    private void openStatusScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new TunnelStatusScreen(this.parent));
    }

    private void openAdvancedScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new AdvancedStatusScreen(this.parent));
    }

    private void reloadConfig() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.f_108617_ != null) {
            player.f_108617_.m_246623_("tunnel config reload");
            this.showSuccess("Config reloaded");
        }
    }

    private void showSuccess(String message) {
        this.statusMessage = "\u00a7a" + message;
        this.statusIsError = false;
        this.statusMessageTimer = 100;
    }

    private void showError(String message) {
        this.statusMessage = "\u00a7c" + message;
        this.statusIsError = true;
        this.statusMessageTimer = 100;
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.maxPeersInput != null) {
            this.maxPeersInput.m_94120_();
        }
        if (this.ttlInput != null) {
            this.ttlInput.m_94120_();
        }
        if (this.portInput != null) {
            this.portInput.m_94120_();
        }
    }
}

