/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.nat;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.model.types.UnsignedIntegerTwoBytes;
import org.fourthline.cling.support.igd.PortMappingListener;
import org.fourthline.cling.support.model.PortMapping;
import org.texboobcat.tunnelyP2p.nat.StunClient;
import org.texboobcat.tunnelyP2p.util.Log;

public class NATTraversal {
    private UpnpService upnpService;
    private PortMapping currentMapping;
    private volatile boolean upnpSuccess = false;

    public int openPortUPnP(int internalPort, int externalPort, String description) {
        try {
            if (externalPort == 0) {
                externalPort = internalPort;
            }
            String internalClient = InetAddress.getLocalHost().getHostAddress();
            this.currentMapping = internalPort == externalPort ? new PortMapping(externalPort, internalClient, PortMapping.Protocol.TCP, description) : new PortMapping(true, new UnsignedIntegerFourBytes(0L), null, new UnsignedIntegerTwoBytes(externalPort), new UnsignedIntegerTwoBytes(internalPort), internalClient, PortMapping.Protocol.TCP, description);
            this.upnpService = new UpnpServiceImpl(new PortMappingListener(this.currentMapping));
            this.upnpService.getControlPoint().search();
            boolean verified = false;
            for (int i = 0; i < 6 && !verified; ++i) {
                Thread.sleep(500L);
                verified = this.verifyPortMapping(externalPort);
            }
            this.upnpSuccess = verified;
            if (verified) {
                Log.d("[UPnP] Port mapping verified: " + internalPort + " -> " + externalPort);
                return externalPort;
            }
            Log.e("[UPnP] Port mapping could not be verified. Router may not support UPnP or rejected mapping.");
            return -1;
        }
        catch (Exception e) {
            Log.e("[UPnP] Failed to create port mapping: " + e.getMessage());
            this.upnpSuccess = false;
            return -1;
        }
    }

    public void closePort() {
        if (this.upnpService != null) {
            this.upnpService.shutdown();
            this.upnpService = null;
            this.upnpSuccess = false;
            Log.d("[UPnP] Port mapping closed");
        }
    }

    public boolean isUpnpSuccess() {
        return this.upnpSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPublicIP() {
        String[] services;
        try {
            String stunIp = StunClient.getPublicIP();
            if (NATTraversal.isValidIP(stunIp)) {
                return stunIp;
            }
        }
        catch (Throwable stunIp) {
            // empty catch block
        }
        String[] stringArray = services = new String[]{"https://api.ipify.org", "https://checkip.amazonaws.com", "https://icanhazip.com"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String service = stringArray[n2];
            try {
                URL url = new URL(service);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String ip = reader.readLine();
                    if (ip != null && NATTraversal.isValidIP(ip = ip.trim())) {
                        String string = ip;
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private static boolean isValidIP(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIPv6(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return addr instanceof Inet6Address;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIP() {
        try (DatagramSocket socket2222 = new DatagramSocket();){
            socket2222.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String addr = socket2222.getLocalAddress().getHostAddress();
            if (!NATTraversal.isIPv6(addr)) {
                String string = addr;
                return string;
            }
        }
        catch (Exception socket2222) {
            // empty catch block
        }
        try {
            String addr = InetAddress.getLocalHost().getHostAddress();
            if (NATTraversal.isIPv6(addr)) return "127.0.0.1";
            return addr;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIPv6() {
        try (DatagramSocket socket2222 = new DatagramSocket();){
            socket2222.connect(InetAddress.getByName("2001:4860:4860::8888"), 10002);
            String addr = socket2222.getLocalAddress().getHostAddress();
            if (NATTraversal.isIPv6(addr)) {
                int percentIdx = addr.indexOf(37);
                if (percentIdx > 0) {
                    addr = addr.substring(0, percentIdx);
                }
                if (addr.startsWith("2") || addr.startsWith("3")) {
                    String string = addr;
                    return string;
                }
            }
        }
        catch (Exception socket2222) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet6Address)) continue;
                    String ipv6 = addr.getHostAddress();
                    int percentIdx = ipv6.indexOf(37);
                    if (percentIdx > 0) {
                        ipv6 = ipv6.substring(0, percentIdx);
                    }
                    if (!ipv6.startsWith("2") && !ipv6.startsWith("3")) continue;
                    return ipv6;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPublicIPv6() {
        String[] services;
        try {
            String stunIp = StunClient.getPublicIPv6();
            if (NATTraversal.isValidIP(stunIp) && NATTraversal.isIPv6(stunIp)) {
                return stunIp;
            }
        }
        catch (Throwable stunIp) {
            // empty catch block
        }
        String[] stringArray = services = new String[]{"https://api64.ipify.org", "https://v6.ident.me"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String service = stringArray[n2];
            try {
                URL url = new URL(service);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String ip = reader.readLine();
                    if (ip != null && NATTraversal.isValidIP(ip = ip.trim()) && NATTraversal.isIPv6(ip)) {
                        String string = ip;
                        return string;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasIPv6Connectivity() {
        DatagramSocket socket = new DatagramSocket();
        try {
            socket.connect(InetAddress.getByName("2001:4860:4860::8888"), 10002);
            socket.setSoTimeout(1000);
            boolean bl = true;
            socket.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static NATType detectNATType() {
        try {
            NATType t = StunClient.detectNatType();
            if (t != null) {
                return t;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String publicIP = NATTraversal.getPublicIP();
            String localIP = NATTraversal.getLocalIP();
            if (publicIP == null) {
                return NATType.UNKNOWN;
            }
            if (publicIP.equals(localIP)) {
                return NATType.NONE;
            }
            return NATType.UNKNOWN_NAT;
        }
        catch (Exception e) {
            return NATType.UNKNOWN;
        }
    }

    private boolean verifyPortMapping(int externalPort) {
        if (this.upnpService == null) {
            return false;
        }
        try {
            for (RemoteDevice device : this.upnpService.getRegistry().getRemoteDevices()) {
                RemoteService service = (RemoteService)device.findService(new UDAServiceType("WANIPConnection", 1));
                if (service == null) {
                    service = (RemoteService)device.findService(new UDAServiceType("WANPPPConnection", 1));
                }
                if (service == null) continue;
                ActionInvocation invocation = new ActionInvocation(service.getAction("GetSpecificPortMappingEntry"));
                invocation.setInput("NewRemoteHost", "");
                invocation.setInput("NewExternalPort", new UnsignedIntegerTwoBytes(externalPort));
                invocation.setInput("NewProtocol", "TCP");
                final boolean[] ok = new boolean[]{false};
                ActionCallback callback = new ActionCallback(invocation){

                    @Override
                    public void success(ActionInvocation invocation) {
                        ok[0] = true;
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                    }
                };
                callback.run();
                if (!ok[0]) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static enum NATType {
        NONE("No NAT - Direct connection"),
        FULL_CONE("Full Cone NAT - Easy traversal"),
        RESTRICTED_CONE("Restricted Cone NAT - Moderate traversal"),
        PORT_RESTRICTED("Port Restricted Cone NAT - Difficult traversal"),
        SYMMETRIC("Symmetric NAT - Very difficult traversal"),
        UNKNOWN_NAT("NAT detected - Type unknown"),
        UNKNOWN("Unknown configuration");

        private final String description;

        private NATType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

