/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.shared;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.support.shared.AWTExceptionHandler;
import org.fourthline.cling.support.shared.TextExpandEvent;
import org.seamless.swing.AbstractController;
import org.seamless.swing.Application;
import org.seamless.swing.logging.LogCategory;
import org.seamless.swing.logging.LogController;
import org.seamless.swing.logging.LogMessage;
import org.seamless.swing.logging.LoggingHandler;
import org.seamless.util.logging.LoggingUtil;

public abstract class MainController
extends AbstractController<JFrame> {
    private final LogController logController;
    private final JPanel logPanel;

    public MainController(JFrame view, List<LogCategory> logCategories) {
        super(view);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            System.out.println("Unable to load native look and feel: " + ex.toString());
        }
        System.setProperty("sun.awt.exception.handler", AWTExceptionHandler.class.getName());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (MainController.this.getUpnpService() != null) {
                    MainController.this.getUpnpService().shutdown();
                }
            }
        });
        this.logController = new LogController(this, logCategories){

            @Override
            protected void expand(LogMessage logMessage) {
                this.fireEventGlobal(new TextExpandEvent(logMessage.getMessage()));
            }

            @Override
            protected Frame getParentWindow() {
                return (Frame)MainController.this.getView();
            }
        };
        this.logPanel = (JPanel)this.logController.getView();
        this.logPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        LoggingHandler handler = new LoggingHandler(){

            @Override
            protected void log(LogMessage msg) {
                MainController.this.logController.pushMessage(msg);
            }
        };
        if (System.getProperty("java.util.logging.config.file") == null) {
            LoggingUtil.resetRootHandler(handler);
        } else {
            LogManager.getLogManager().getLogger("").addHandler(handler);
        }
    }

    public LogController getLogController() {
        return this.logController;
    }

    public JPanel getLogPanel() {
        return this.logPanel;
    }

    public void log(Level level, String msg) {
        this.log(new LogMessage(level, msg));
    }

    public void log(LogMessage message) {
        this.getLogController().pushMessage(message);
    }

    @Override
    public void dispose() {
        super.dispose();
        ShutdownWindow.INSTANCE.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                System.exit(0);
            }
        }.start();
    }

    public abstract UpnpService getUpnpService();

    public static class ShutdownWindow
    extends JWindow {
        public static final JWindow INSTANCE = new ShutdownWindow();

        protected ShutdownWindow() {
            JLabel shutdownLabel = new JLabel("Shutting down, please wait...");
            shutdownLabel.setHorizontalAlignment(0);
            this.getContentPane().add(shutdownLabel);
            this.setPreferredSize(new Dimension(300, 30));
            this.pack();
            Application.center(this);
        }
    }
}

