/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.texboobcat.tunnelyP2p.connection.LocalProxy;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.connection.TunnelServer;

public class TunnelManager {
    private static TunnelManager instance;
    private TunnelServer activeServer;
    private LocalProxy activeProxy;

    private TunnelManager() {
    }

    public static synchronized TunnelManager getInstance() {
        if (instance == null) {
            instance = new TunnelManager();
        }
        return instance;
    }

    public synchronized String createHostSession(int bindPort, String minecraftHost, int minecraftPort, int maxPeers, long ttlSeconds) throws Exception {
        if (this.activeServer != null) {
            throw new IllegalStateException("Host session already active. Stop it first.");
        }
        if (this.activeProxy != null) {
            throw new IllegalStateException("Client session already active. Cannot host and connect simultaneously.");
        }
        this.activeServer = new TunnelServer(bindPort, minecraftHost, minecraftPort, maxPeers, ttlSeconds);
        this.activeServer.start();
        return this.activeServer.getConnectionToken();
    }

    public synchronized void connectToHost(String token, int localPort, UUID playerUUID, String playerName) throws Exception {
        if (this.activeProxy != null) {
            throw new IllegalStateException("Already connected to a host. Disconnect first.");
        }
        if (this.activeServer != null) {
            throw new IllegalStateException("Host session active. Cannot connect while hosting.");
        }
        this.activeProxy = new LocalProxy(localPort, token, playerUUID, playerName);
        try {
            this.activeProxy.start();
        }
        catch (Exception e) {
            try {
                this.activeProxy.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.activeProxy = null;
            throw e;
        }
    }

    public synchronized void stopHostSession() {
        if (this.activeServer != null) {
            this.activeServer.close();
            this.activeServer = null;
        }
    }

    public synchronized void disconnect() {
        if (this.activeProxy != null) {
            this.activeProxy.close();
            this.activeProxy = null;
        }
    }

    public synchronized void stopAll() {
        this.stopHostSession();
        this.disconnect();
    }

    public boolean isHosting() {
        return this.activeServer != null && this.activeServer.isRunning();
    }

    public boolean isConnected() {
        return this.activeProxy != null && this.activeProxy.isConnected();
    }

    public TunnelServer getActiveServer() {
        return this.activeServer;
    }

    public LocalProxy getActiveProxy() {
        return this.activeProxy;
    }

    public Collection<PeerConnection> getConnectedPeers() {
        if (this.activeServer != null) {
            return this.activeServer.getConnectedPeers();
        }
        return Collections.emptyList();
    }

    public SessionStatus getStatus() {
        SessionStatus status = new SessionStatus();
        if (this.isHosting()) {
            status.mode = "host";
            status.active = true;
            status.peerCount = this.activeServer.getConnectedPeers().size();
        } else if (this.isConnected()) {
            status.mode = "client";
            status.active = true;
            status.localPort = this.activeProxy.getLocalPort();
            PeerConnection peer = this.activeProxy.getPeerConnection();
            if (peer != null) {
                status.hostName = peer.getPeerName();
                status.bytesSent = peer.getBytesSent();
                status.bytesReceived = peer.getBytesReceived();
            }
        } else {
            status.mode = "inactive";
            status.active = false;
        }
        return status;
    }

    public static class SessionStatus {
        public String mode;
        public boolean active;
        public int peerCount;
        public int localPort;
        public String hostName;
        public long bytesSent;
        public long bytesReceived;
    }
}

