/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.crypto;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public class KeyPairHolder {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final byte[] publicKeyBytes;

    public KeyPairHolder(PrivateKey privateKey, PublicKey publicKey, byte[] publicKeyBytes) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.publicKeyBytes = Arrays.copyOf(publicKeyBytes, publicKeyBytes.length);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPublicKeyBytes() {
        return Arrays.copyOf(this.publicKeyBytes, this.publicKeyBytes.length);
    }

    public void clear() {
        Arrays.fill(this.publicKeyBytes, (byte)0);
    }
}

