/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;
import org.texboobcat.tunnelyP2p.i18n.I18n;

public class AdvancedStatusScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 closeButton;
    private class_4185 stopButton;
    private class_4185 basicViewButton;
    private class_4185 alternativeModButton;
    private int currentTab = 0;

    public AdvancedStatusScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)I18n.t("gui.tunnel.title", new Object[0])));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int startX = this.field_22789 / 2 - (buttonWidth * 3 + buttonSpacing * 2) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Overview"), button -> {
            this.currentTab = 0;
        }).method_46434(startX, 35, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Metrics"), button -> {
            this.currentTab = 1;
        }).method_46434(startX + buttonWidth + buttonSpacing, 35, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Advanced"), button -> {
            this.currentTab = 2;
        }).method_46434(startX + (buttonWidth + buttonSpacing) * 2, 35, buttonWidth, buttonHeight).method_46431());
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)I18n.t("gui.tunnel.close", new Object[0])), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - buttonWidth - buttonSpacing, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431();
        this.stopButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)I18n.t("gui.tunnel.stop", new Object[0])), button -> {
            TunnelManager.getInstance().stopAll();
            this.field_22787.method_1507(this.parent);
        }).method_46434(this.field_22789 / 2 + buttonSpacing, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431();
        this.alternativeModButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76Tunnely"), button -> this.showAlternativeModInfo()).method_46434(this.field_22789 - 110, 10, 100, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.method_37063((class_364)this.alternativeModButton);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (status.active) {
            this.method_37063((class_364)this.stopButton);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        graphics.method_25300(this.field_22793, "\u00a7b\u00a7lTunnely P2P - Advanced Status", this.field_22789 / 2, 15, 0xFFFFFF);
        switch (this.currentTab) {
            case 0: {
                this.renderOverview(graphics, status);
                break;
            }
            case 1: {
                this.renderMetrics(graphics, status);
                break;
            }
            case 2: {
                this.renderAdvanced(graphics, status);
            }
        }
    }

    private void renderOverview(class_332 graphics, TunnelManager.SessionStatus status) {
        int centerX = this.field_22789 / 2;
        int startY = 70;
        int lineHeight = 12;
        if (!status.active) {
            graphics.method_25300(this.field_22793, "\u00a77Status: \u00a7cInactive", centerX, startY, 0xFFFFFF);
            graphics.method_25300(this.field_22793, I18n.t("gui.tunnel.noactive", new Object[0]), centerX, startY + lineHeight * 2, 0xAAAAAA);
            return;
        }
        if ("host".equals(status.mode)) {
            graphics.method_25300(this.field_22793, "\u00a77Mode: \u00a7aHost \u00a77\u2502 \u00a77Peers: \u00a7f" + status.peerCount, centerX, startY, 0xFFFFFF);
            int y = startY + lineHeight * 2;
            if (status.peerCount > 0) {
                graphics.method_25300(this.field_22793, "\u00a76Connected Players:", centerX, y, 0xFFFFFF);
                y += lineHeight * 2;
                for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                    String peerInfo = String.format("\u00a7f%s \u00a78\u2502 \u00a77\u2191%s \u00a77\u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                    graphics.method_25300(this.field_22793, peerInfo, centerX, y, 0xFFFFFF);
                    y += lineHeight;
                }
            } else {
                graphics.method_25300(this.field_22793, "\u00a77Waiting for connections...", centerX, y, 0xAAAAAA);
            }
        } else if ("client".equals(status.mode)) {
            graphics.method_25300(this.field_22793, "\u00a77Mode: \u00a7aClient \u00a77\u2502 \u00a77Host: \u00a7f" + status.hostName, centerX, startY, 0xFFFFFF);
            int y = startY + lineHeight * 2;
            graphics.method_25300(this.field_22793, "\u00a77Proxy Address: \u00a7f127.0.0.1:" + status.localPort, centerX, y, 0xFFFFFF);
            long totalBytes = status.bytesSent + status.bytesReceived;
            String quality = this.getQualityIndicator(totalBytes);
            graphics.method_25300(this.field_22793, "\u00a77Connection: " + quality, centerX, y += lineHeight, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77Uploaded: \u00a7f" + this.formatBytes(status.bytesSent), centerX, y += lineHeight * 2, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77Downloaded: \u00a7f" + this.formatBytes(status.bytesReceived), centerX, y += lineHeight, 0xFFFFFF);
        }
    }

    private void renderMetrics(class_332 graphics, TunnelManager.SessionStatus status) {
        int leftX = this.field_22789 / 4;
        int rightX = this.field_22789 * 3 / 4;
        int startY = 70;
        int lineHeight = 12;
        if (!status.active) {
            graphics.method_25300(this.field_22793, "\u00a77No active session", this.field_22789 / 2, startY + lineHeight * 3, 0xAAAAAA);
            return;
        }
        int y = startY;
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lTraffic Statistics", leftX - 60, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Sent:", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7f" + this.formatBytes(status.bytesSent), leftX + 10, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Received:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7f" + this.formatBytes(status.bytesReceived), leftX + 10, y, 0xFFFFFF);
        long total = status.bytesSent + status.bytesReceived;
        graphics.method_25303(this.field_22793, "\u00a77Total:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7f" + this.formatBytes(total), leftX + 10, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lConnection Info", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Protocol:", leftX - 60, y += lineHeight * 2, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7fTCP/Encrypted", leftX + 10, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a77Encryption:", leftX - 60, y += lineHeight, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7aChaCha20-Poly1305", leftX + 10, y, 0xFFFFFF);
        y = startY;
        graphics.method_25303(this.field_22793, "\u00a7e\u00a7lPerformance", rightX - 60, y, 0xFFFFFF);
        y += lineHeight * 2;
        if ("client".equals(status.mode)) {
            PeerConnection peer;
            PeerConnection peerConnection = peer = TunnelManager.getInstance().getActiveProxy() != null ? TunnelManager.getInstance().getActiveProxy().getPeerConnection() : null;
            if (peer != null) {
                long latency = peer.getLatency();
                graphics.method_25303(this.field_22793, "\u00a77Latency:", rightX - 60, y, 0xFFFFFF);
                graphics.method_25303(this.field_22793, this.getLatencyColor(latency) + latency + "ms", rightX + 10, y, 0xFFFFFF);
                y += lineHeight;
            }
        }
        String qualityText = "\u00a7aExcellent";
        if (total < 102400L) {
            qualityText = "\u00a77Starting...";
        } else if (total > 0x6400000L) {
            qualityText = "\u00a76Heavy";
        }
        graphics.method_25303(this.field_22793, "\u00a77Quality:", rightX - 60, y, 0xFFFFFF);
        graphics.method_25303(this.field_22793, qualityText, rightX + 10, y, 0xFFFFFF);
    }

    private void renderAdvanced(class_332 graphics, TunnelManager.SessionStatus status) {
        int centerX = this.field_22789 / 2;
        int startY = 70;
        int lineHeight = 12;
        int y = startY;
        graphics.method_25300(this.field_22793, "\u00a7e\u00a7lAdvanced Information", centerX, y, 0xFFFFFF);
        y += lineHeight * 2;
        if (!status.active) {
            graphics.method_25300(this.field_22793, "\u00a77No active session", centerX, y + lineHeight * 2, 0xAAAAAA);
            return;
        }
        graphics.method_25300(this.field_22793, "\u00a77Session Mode: \u00a7f" + ("host".equals(status.mode) ? "Server (Hosting)" : "Client (Connected)"), centerX, y, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Key Exchange: \u00a7fX25519 ECDH", centerX, y += lineHeight, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Cipher: \u00a7fChaCha20-Poly1305 (AEAD)", centerX, y += lineHeight, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Key Derivation: \u00a7fHKDF-SHA256", centerX, y += lineHeight, 0xFFFFFF);
        y += lineHeight * 2;
        if ("host".equals(status.mode)) {
            graphics.method_25300(this.field_22793, "\u00a77Max Peers: \u00a7f4 \u00a78\u2502 \u00a77NAT: \u00a7fUPnP", centerX, y, 0xFFFFFF);
        } else {
            graphics.method_25300(this.field_22793, "\u00a77Connection Strategy: \u00a7fDirect TCP", centerX, y, 0xFFFFFF);
        }
        graphics.method_25300(this.field_22793, "\u00a7a\u2713 \u00a77End-to-end encrypted", centerX, y += lineHeight * 2, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a7a\u2713 \u00a77Authenticated session", centerX, y += lineHeight, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a7a\u2713 \u00a77Forward secrecy", centerX, y += lineHeight, 0xFFFFFF);
    }

    private String getQualityIndicator(long totalBytes) {
        if (totalBytes < 10240L) {
            return "\u00a77Starting...";
        }
        if (totalBytes > 0x3200000L) {
            return "\u00a7aExcellent";
        }
        if (totalBytes > 0xA00000L) {
            return "\u00a72Good";
        }
        return "\u00a7eActive";
    }

    private String getLatencyColor(long latency) {
        if (latency < 50L) {
            return "\u00a7a";
        }
        if (latency < 100L) {
            return "\u00a72";
        }
        if (latency < 200L) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private void showAlternativeModInfo() {
        String downloadUrl = "https://modrinth.com/mod/tunnely";
        class_5250 title = class_2561.method_43470((String)"\u00a76\u00a7lTunnely - Alternative Version");
        String message = "\u00a77Tunnely is designed for modpacks and public servers:\n\n\u00a7a\u2713 Public Server Browser \u00a77with mod compatibility checks\n\u00a7a\u2713 Mesh-Relay System \u00a77for improved ping and stability\n\u00a7a\u2713 Database-backed \u00a77connection management\n\u00a7a\u2713 Better for large communities \u00a77and modpack integration\n\n\u00a7eThis P2P version \u00a77is better for private, direct connections.\n\u00a7eThe standard version \u00a77is better for public servers and modpacks.";
        this.field_22787.method_1507((class_437)new class_407(confirmed -> {
            if (confirmed) {
                try {
                    Desktop.getDesktop().browse(URI.create(downloadUrl));
                }
                catch (Exception e) {
                    try {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + downloadUrl);
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec("open " + downloadUrl);
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec("xdg-open " + downloadUrl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)title, message, (class_2561)class_2561.method_43470((String)"Back"), true));
    }
}

