/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.texboobcat.tunnelyP2p.TunnelManager;
import org.texboobcat.tunnelyP2p.connection.PeerConnection;

public class TunnelStatusScreen
extends class_437 {
    private final class_437 parent;
    private class_4185 closeButton;
    private class_4185 stopButton;
    private class_4185 alternativeModButton;

    public TunnelStatusScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Tunnel Status"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - buttonWidth - buttonSpacing, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431();
        this.stopButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Stop Session"), button -> {
            TunnelManager.getInstance().stopAll();
            this.field_22787.method_1507(this.parent);
        }).method_46434(this.field_22789 / 2 + buttonSpacing, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431();
        this.alternativeModButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a76Tunnely"), button -> this.showAlternativeModInfo()).method_46434(this.field_22789 - 110, 10, 100, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.method_37063((class_364)this.alternativeModButton);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        if (status.active) {
            this.method_37063((class_364)this.stopButton);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        TunnelManager.SessionStatus status = TunnelManager.getInstance().getStatus();
        int centerX = this.field_22789 / 2;
        int startY = 40;
        int lineHeight = 12;
        graphics.method_25300(this.field_22793, "\u00a7b\u00a7lTunnel Status", centerX, 20, 0xFFFFFF);
        if (!status.active) {
            graphics.method_25300(this.field_22793, "\u00a77Status: \u00a7cInactive", centerX, startY, 0xFFFFFF);
            graphics.method_25300(this.field_22793, "\u00a77No active tunnel session", centerX, startY + lineHeight * 2, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a77Use \u00a7f/tunnel create \u00a77to host", centerX, startY + lineHeight * 3, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a77Use \u00a7f/tunnel connect <token> \u00a77to join", centerX, startY + lineHeight * 4, 0xAAAAAA);
        } else if ("host".equals(status.mode)) {
            this.renderHostStatus(graphics, status, centerX, startY, lineHeight);
        } else if ("client".equals(status.mode)) {
            this.renderClientStatus(graphics, status, centerX, startY, lineHeight);
        }
    }

    private void renderHostStatus(class_332 graphics, TunnelManager.SessionStatus status, int centerX, int startY, int lineHeight) {
        graphics.method_25300(this.field_22793, "\u00a77Mode: \u00a7aHost", centerX, startY, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Connected Peers: \u00a7f" + status.peerCount, centerX, startY + lineHeight, 0xFFFFFF);
        int y = startY + lineHeight * 3;
        if (status.peerCount > 0) {
            graphics.method_25300(this.field_22793, "\u00a77Connected Players:", centerX, y, 0xFFFFFF);
            y += lineHeight * 2;
            for (PeerConnection peer : TunnelManager.getInstance().getConnectedPeers()) {
                String peerInfo = String.format("\u00a7f%s \u00a77- \u2191%s \u2193%s", peer.getPeerName(), this.formatBytes(peer.getBytesSent()), this.formatBytes(peer.getBytesReceived()));
                graphics.method_25300(this.field_22793, peerInfo, centerX, y, 0xFFFFFF);
                y += lineHeight;
            }
        } else {
            graphics.method_25300(this.field_22793, "\u00a77No peers connected yet", centerX, y, 0xAAAAAA);
            graphics.method_25300(this.field_22793, "\u00a77Use \u00a7f/tunnel token \u00a77to get the connection token", centerX, y += lineHeight * 2, 0xAAAAAA);
        }
    }

    private void renderClientStatus(class_332 graphics, TunnelManager.SessionStatus status, int centerX, int startY, int lineHeight) {
        graphics.method_25300(this.field_22793, "\u00a77Mode: \u00a7aClient", centerX, startY, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Connected to: \u00a7f" + status.hostName, centerX, startY + lineHeight, 0xFFFFFF);
        int y = startY + lineHeight * 3;
        graphics.method_25300(this.field_22793, "\u00a77Local Proxy: \u00a7flocalhost:" + status.localPort, centerX, y, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Data Sent: \u00a7f" + this.formatBytes(status.bytesSent), centerX, y += lineHeight, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Data Received: \u00a7f" + this.formatBytes(status.bytesReceived), centerX, y += lineHeight, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a7aAdd server: \u00a7f127.0.0.1:" + status.localPort, centerX, y += lineHeight * 2, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Connect to join the host's server", centerX, y += lineHeight, 0xAAAAAA);
    }

    private String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1fKB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1fMB", (double)bytes / 1048576.0);
        }
        return String.format("%.1fGB", (double)bytes / 1.073741824E9);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private void showAlternativeModInfo() {
        String downloadUrl = "https://modrinth.com/mod/tunnely";
        class_5250 title = class_2561.method_43470((String)"\u00a76\u00a7lTunnely - Alternative Version");
        String message = "\u00a77Tunnely is designed for modpacks and public servers:\n\n\u00a7a\u2713 Public Server Browser \u00a77with mod compatibility checks\n\u00a7a\u2713 Mesh-Relay System \u00a77for improved ping and stability\n\u00a7a\u2713 Database-backed \u00a77connection management\n\u00a7a\u2713 Better for large communities \u00a77and modpack integration\n\n\u00a7eThis P2P version \u00a77is better for private, direct connections.\n\u00a7eThe standard version \u00a77is better for public servers and modpacks.";
        this.field_22787.method_1507((class_437)new class_407(confirmed -> {
            if (confirmed) {
                try {
                    Desktop.getDesktop().browse(URI.create(downloadUrl));
                }
                catch (Exception e) {
                    try {
                        String os = System.getProperty("os.name").toLowerCase();
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + downloadUrl);
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec("open " + downloadUrl);
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec("xdg-open " + downloadUrl);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)title, message, (class_2561)class_2561.method_43470((String)"Back"), true));
    }
}

