/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.nat;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.texboobcat.tunnelyP2p.util.Log;

public class TcpHolePuncher {
    private static final int PUNCH_TIMEOUT_MS = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket punchHole(int localPort, String remoteIP, int remotePort) {
        Socket socket;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Socket> connectFuture = executor.submit(() -> TcpHolePuncher.attemptSimultaneousConnect(localPort, remoteIP, remotePort));
            Socket socket2 = connectFuture.get(3000L, TimeUnit.MILLISECONDS);
            if (socket2 != null && socket2.isConnected()) {
                Log.d("[TCP Hole Punch] Success! Connected to " + remoteIP + ":" + remotePort);
                Socket socket3 = socket2;
                return socket3;
            }
            Socket socket4 = null;
            return socket4;
        }
        catch (TimeoutException e) {
            Log.d("[TCP Hole Punch] Timeout");
            socket = null;
            return socket;
        }
        catch (Exception e) {
            Log.d("[TCP Hole Punch] Failed: " + e.getMessage());
            socket = null;
            return socket;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static Socket attemptSimultaneousConnect(int localPort, String remoteIP, int remotePort) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(3000);
            socket.bind(new InetSocketAddress(localPort));
            InetSocketAddress remoteAddress = new InetSocketAddress(remoteIP, remotePort);
            socket.connect(remoteAddress, 3000);
            if (socket.isConnected()) {
                return socket;
            }
        }
        catch (ConnectException e) {
            for (int retry = 0; retry < 3; ++retry) {
                try {
                    Thread.sleep(100L);
                    socket = new Socket();
                    socket.setReuseAddress(true);
                    socket.setSoTimeout(3000);
                    socket.bind(new InetSocketAddress(localPort));
                    socket.connect(new InetSocketAddress(remoteIP, remotePort), 3000);
                    if (!socket.isConnected()) continue;
                    return socket;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket waitForPunch(int localPort, String remoteIP, int remotePort, long timeoutMs) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<Socket> listenFuture = executor.submit(() -> TcpHolePuncher.listenForConnection(localPort, timeoutMs));
            Future<Socket> connectFuture = executor.submit(() -> TcpHolePuncher.attemptSimultaneousConnect(localPort, remoteIP, remotePort));
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < timeoutMs) {
                Socket socket;
                if (listenFuture.isDone() && (socket = listenFuture.get()) != null) {
                    connectFuture.cancel(true);
                    Socket socket2 = socket;
                    return socket2;
                }
                if (connectFuture.isDone() && (socket = connectFuture.get()) != null) {
                    listenFuture.cancel(true);
                    Socket socket3 = socket;
                    return socket3;
                }
                Thread.sleep(50L);
            }
            Socket socket = null;
            return socket;
        }
        catch (Exception e) {
            Socket socket = null;
            return socket;
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Socket listenForConnection(int localPort, long timeoutMs) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(localPort));
            serverSocket.setSoTimeout((int)timeoutMs);
            Socket socket = serverSocket.accept();
            Log.d("[TCP Hole Punch] Accepted connection from " + String.valueOf(socket.getRemoteSocketAddress()));
            Socket socket2 = socket;
            return socket2;
        }
        catch (SocketTimeoutException e) {
            Socket socket = null;
            return socket;
        }
        catch (IOException e) {
            Socket socket = null;
            return socket;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

