/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class AuthChallengeMessage
extends ProtocolMessage {
    private final byte[] nonce;

    public AuthChallengeMessage(byte[] nonce) {
        super(ProtocolMessage.MessageType.AUTH_CHALLENGE);
        this.nonce = nonce;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        this.writeByteArray(dos, this.nonce);
        return baos.toByteArray();
    }

    public static AuthChallengeMessage deserializeFrom(DataInputStream dis) throws IOException {
        byte[] nonce = new AuthChallengeMessage(null).readByteArray(dis);
        return new AuthChallengeMessage(nonce);
    }
}

