/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.token;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ConnectionToken {
    private static final int PROTOCOL_VERSION = 1;
    private final int protocolVersion;
    private final UUID sessionId;
    private final byte[] hostPublicKey;
    private final NATInfo natInfo;
    private final long timestamp;
    private final long ttlSeconds;
    private final UUID hostPlayerUUID;
    private final String hostPlayerName;
    private final byte[] signature;

    public ConnectionToken(UUID sessionId, byte[] hostPublicKey, NATInfo natInfo, long timestamp, long ttlSeconds, UUID hostPlayerUUID, String hostPlayerName, byte[] signature) {
        this.protocolVersion = 1;
        this.sessionId = sessionId;
        this.hostPublicKey = hostPublicKey;
        this.natInfo = natInfo;
        this.timestamp = timestamp;
        this.ttlSeconds = ttlSeconds;
        this.hostPlayerUUID = hostPlayerUUID;
        this.hostPlayerName = hostPlayerName;
        this.signature = signature;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public byte[] getHostPublicKey() {
        return this.hostPublicKey;
    }

    public NATInfo getNatInfo() {
        return this.natInfo;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTtlSeconds() {
        return this.ttlSeconds;
    }

    public UUID getHostPlayerUUID() {
        return this.hostPlayerUUID;
    }

    public String getHostPlayerName() {
        return this.hostPlayerName;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isExpired() {
        long currentTime = System.currentTimeMillis() / 1000L;
        return currentTime > this.timestamp + this.ttlSeconds;
    }

    public long getRemainingSeconds() {
        long currentTime = System.currentTimeMillis() / 1000L;
        long expiryTime = this.timestamp + this.ttlSeconds;
        return Math.max(0L, expiryTime - currentTime);
    }

    public static class NATInfo {
        private final String publicIP;
        private final Integer publicPort;
        private final String localIP;
        private final Integer localPort;
        private final boolean upnpSuccess;
        private final List<Integer> udpPorts;

        public NATInfo(String publicIP, Integer publicPort, String localIP, Integer localPort, boolean upnpSuccess, List<Integer> udpPorts) {
            this.publicIP = publicIP;
            this.publicPort = publicPort;
            this.localIP = localIP;
            this.localPort = localPort;
            this.upnpSuccess = upnpSuccess;
            this.udpPorts = udpPorts != null ? new ArrayList<Integer>(udpPorts) : new ArrayList();
        }

        public String getPublicIP() {
            return this.publicIP;
        }

        public Integer getPublicPort() {
            return this.publicPort;
        }

        public String getLocalIP() {
            return this.localIP;
        }

        public Integer getLocalPort() {
            return this.localPort;
        }

        public boolean isUpnpSuccess() {
            return this.upnpSuccess;
        }

        public List<Integer> getUdpPorts() {
            return new ArrayList<Integer>(this.udpPorts);
        }

        public boolean hasPublicEndpoint() {
            return this.publicIP != null && this.publicPort != null;
        }

        public boolean hasLocalEndpoint() {
            return this.localIP != null && this.localPort != null;
        }
    }
}

