/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.binding.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.fourthline.cling.binding.LocalServiceBindingException;
import org.fourthline.cling.binding.annotations.AnnotationLocalServiceBinder;
import org.fourthline.cling.binding.annotations.UpnpAction;
import org.fourthline.cling.binding.annotations.UpnpInputArgument;
import org.fourthline.cling.binding.annotations.UpnpOutputArgument;
import org.fourthline.cling.model.ModelUtil;
import org.fourthline.cling.model.action.ActionExecutor;
import org.fourthline.cling.model.action.MethodActionExecutor;
import org.fourthline.cling.model.meta.Action;
import org.fourthline.cling.model.meta.ActionArgument;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.meta.StateVariable;
import org.fourthline.cling.model.profile.RemoteClientInfo;
import org.fourthline.cling.model.state.GetterStateVariableAccessor;
import org.fourthline.cling.model.state.StateVariableAccessor;
import org.fourthline.cling.model.types.Datatype;
import org.seamless.util.Reflections;

public class AnnotationActionBinder {
    private static Logger log = Logger.getLogger(AnnotationLocalServiceBinder.class.getName());
    protected UpnpAction annotation;
    protected Method method;
    protected Map<StateVariable, StateVariableAccessor> stateVariables;
    protected Set<Class> stringConvertibleTypes;

    public AnnotationActionBinder(Method method, Map<StateVariable, StateVariableAccessor> stateVariables, Set<Class> stringConvertibleTypes) {
        this.annotation = method.getAnnotation(UpnpAction.class);
        this.stateVariables = stateVariables;
        this.method = method;
        this.stringConvertibleTypes = stringConvertibleTypes;
    }

    public UpnpAction getAnnotation() {
        return this.annotation;
    }

    public Map<StateVariable, StateVariableAccessor> getStateVariables() {
        return this.stateVariables;
    }

    public Method getMethod() {
        return this.method;
    }

    public Set<Class> getStringConvertibleTypes() {
        return this.stringConvertibleTypes;
    }

    public Action appendAction(Map<Action, ActionExecutor> actions) throws LocalServiceBindingException {
        String name = this.getAnnotation().name().length() != 0 ? this.getAnnotation().name() : AnnotationLocalServiceBinder.toUpnpActionName(this.getMethod().getName());
        log.fine("Creating action and executor: " + name);
        List<ActionArgument> inputArguments = this.createInputArguments();
        Map<ActionArgument<LocalService>, StateVariableAccessor> outputArguments = this.createOutputArguments();
        inputArguments.addAll(outputArguments.keySet());
        ActionArgument[] actionArguments = inputArguments.toArray(new ActionArgument[inputArguments.size()]);
        Action action = new Action(name, actionArguments);
        ActionExecutor executor = this.createExecutor(outputArguments);
        actions.put(action, executor);
        return action;
    }

    protected ActionExecutor createExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArguments) {
        return new MethodActionExecutor(outputArguments, this.getMethod());
    }

    protected List<ActionArgument> createInputArguments() throws LocalServiceBindingException {
        ArrayList<ActionArgument> list = new ArrayList<ActionArgument>();
        int annotatedParams = 0;
        Annotation[][] params = this.getMethod().getParameterAnnotations();
        for (int i = 0; i < params.length; ++i) {
            Annotation[] param;
            for (Annotation paramAnnotation : param = params[i]) {
                if (!(paramAnnotation instanceof UpnpInputArgument)) continue;
                UpnpInputArgument inputArgumentAnnotation = (UpnpInputArgument)paramAnnotation;
                ++annotatedParams;
                String argumentName = inputArgumentAnnotation.name();
                StateVariable stateVariable = this.findRelatedStateVariable(inputArgumentAnnotation.stateVariable(), argumentName, this.getMethod().getName());
                if (stateVariable == null) {
                    throw new LocalServiceBindingException("Could not detected related state variable of argument: " + argumentName);
                }
                this.validateType(stateVariable, this.getMethod().getParameterTypes()[i]);
                ActionArgument inputArgument = new ActionArgument(argumentName, inputArgumentAnnotation.aliases(), stateVariable.getName(), ActionArgument.Direction.IN);
                list.add(inputArgument);
            }
        }
        if (annotatedParams < this.getMethod().getParameterTypes().length && !RemoteClientInfo.class.isAssignableFrom(this.method.getParameterTypes()[this.method.getParameterTypes().length - 1])) {
            throw new LocalServiceBindingException("Method has parameters that are not input arguments: " + this.getMethod().getName());
        }
        return list;
    }

    protected Map<ActionArgument<LocalService>, StateVariableAccessor> createOutputArguments() throws LocalServiceBindingException {
        LinkedHashMap<ActionArgument<LocalService>, StateVariableAccessor> map = new LinkedHashMap<ActionArgument<LocalService>, StateVariableAccessor>();
        UpnpAction actionAnnotation = this.getMethod().getAnnotation(UpnpAction.class);
        if (actionAnnotation.out().length == 0) {
            return map;
        }
        boolean hasMultipleOutputArguments = actionAnnotation.out().length > 1;
        for (UpnpOutputArgument outputArgumentAnnotation : actionAnnotation.out()) {
            String argumentName = outputArgumentAnnotation.name();
            StateVariable stateVariable = this.findRelatedStateVariable(outputArgumentAnnotation.stateVariable(), argumentName, this.getMethod().getName());
            if (stateVariable == null && outputArgumentAnnotation.getterName().length() > 0) {
                stateVariable = this.findRelatedStateVariable(null, null, outputArgumentAnnotation.getterName());
            }
            if (stateVariable == null) {
                throw new LocalServiceBindingException("Related state variable not found for output argument: " + argumentName);
            }
            StateVariableAccessor accessor = this.findOutputArgumentAccessor(stateVariable, outputArgumentAnnotation.getterName(), hasMultipleOutputArguments);
            log.finer("Found related state variable for output argument '" + argumentName + "': " + stateVariable);
            ActionArgument outputArgument = new ActionArgument(argumentName, stateVariable.getName(), ActionArgument.Direction.OUT, !hasMultipleOutputArguments);
            map.put(outputArgument, accessor);
        }
        return map;
    }

    protected StateVariableAccessor findOutputArgumentAccessor(StateVariable stateVariable, String getterName, boolean multipleArguments) throws LocalServiceBindingException {
        boolean isVoid = this.getMethod().getReturnType().equals(Void.TYPE);
        if (isVoid) {
            if (getterName != null && getterName.length() > 0) {
                log.finer("Action method is void, will use getter method named: " + getterName);
                Method getter = Reflections.getMethod(this.getMethod().getDeclaringClass(), getterName);
                if (getter == null) {
                    throw new LocalServiceBindingException("Declared getter method '" + getterName + "' not found on: " + this.getMethod().getDeclaringClass());
                }
                this.validateType(stateVariable, getter.getReturnType());
                return new GetterStateVariableAccessor(getter);
            }
            log.finer("Action method is void, trying to find existing accessor of related: " + stateVariable);
            return this.getStateVariables().get(stateVariable);
        }
        if (getterName != null && getterName.length() > 0) {
            log.finer("Action method is not void, will use getter method on returned instance: " + getterName);
            Method getter = Reflections.getMethod(this.getMethod().getReturnType(), getterName);
            if (getter == null) {
                throw new LocalServiceBindingException("Declared getter method '" + getterName + "' not found on return type: " + this.getMethod().getReturnType());
            }
            this.validateType(stateVariable, getter.getReturnType());
            return new GetterStateVariableAccessor(getter);
        }
        if (!multipleArguments) {
            log.finer("Action method is not void, will use the returned instance: " + this.getMethod().getReturnType());
            this.validateType(stateVariable, this.getMethod().getReturnType());
        }
        return null;
    }

    protected StateVariable findRelatedStateVariable(String declaredName, String argumentName, String methodName) throws LocalServiceBindingException {
        String methodPropertyName;
        String actualName;
        StateVariable relatedStateVariable = null;
        if (declaredName != null && declaredName.length() > 0) {
            relatedStateVariable = this.getStateVariable(declaredName);
        }
        if (relatedStateVariable == null && argumentName != null && argumentName.length() > 0) {
            actualName = AnnotationLocalServiceBinder.toUpnpStateVariableName(argumentName);
            log.finer("Finding related state variable with argument name (converted to UPnP name): " + actualName);
            relatedStateVariable = this.getStateVariable(argumentName);
        }
        if (relatedStateVariable == null && argumentName != null && argumentName.length() > 0) {
            actualName = AnnotationLocalServiceBinder.toUpnpStateVariableName(argumentName);
            actualName = "A_ARG_TYPE_" + actualName;
            log.finer("Finding related state variable with prefixed argument name (converted to UPnP name): " + actualName);
            relatedStateVariable = this.getStateVariable(actualName);
        }
        if (relatedStateVariable == null && methodName != null && methodName.length() > 0 && (methodPropertyName = Reflections.getMethodPropertyName(methodName)) != null) {
            log.finer("Finding related state variable with method property name: " + methodPropertyName);
            relatedStateVariable = this.getStateVariable(AnnotationLocalServiceBinder.toUpnpStateVariableName(methodPropertyName));
        }
        return relatedStateVariable;
    }

    protected void validateType(StateVariable stateVariable, Class type) throws LocalServiceBindingException {
        Datatype.Default expectedDefaultMapping = ModelUtil.isStringConvertibleType(this.getStringConvertibleTypes(), type) ? Datatype.Default.STRING : Datatype.Default.getByJavaType(type);
        log.finer("Expecting '" + stateVariable + "' to match default mapping: " + (Object)((Object)expectedDefaultMapping));
        if (expectedDefaultMapping != null && !stateVariable.getTypeDetails().getDatatype().isHandlingJavaType(expectedDefaultMapping.getJavaType())) {
            throw new LocalServiceBindingException("State variable '" + stateVariable + "' datatype can't handle action argument's Java type (change one): " + expectedDefaultMapping.getJavaType());
        }
        if (expectedDefaultMapping == null && stateVariable.getTypeDetails().getDatatype().getBuiltin() != null) {
            throw new LocalServiceBindingException("State variable '" + stateVariable + "' should be custom datatype (action argument type is unknown Java type): " + type.getSimpleName());
        }
        log.finer("State variable matches required argument datatype (or can't be validated because it is custom)");
    }

    protected StateVariable getStateVariable(String name) {
        for (StateVariable stateVariable : this.getStateVariables().keySet()) {
            if (!stateVariable.getName().equals(name)) continue;
            return stateVariable;
        }
        return null;
    }
}

