/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.igd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDADeviceType;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.registry.DefaultRegistryListener;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.support.igd.callback.PortMappingAdd;
import org.fourthline.cling.support.igd.callback.PortMappingDelete;
import org.fourthline.cling.support.model.PortMapping;

public class PortMappingListener
extends DefaultRegistryListener {
    private static final Logger log = Logger.getLogger(PortMappingListener.class.getName());
    public static final DeviceType IGD_DEVICE_TYPE = new UDADeviceType("InternetGatewayDevice", 1);
    public static final DeviceType CONNECTION_DEVICE_TYPE = new UDADeviceType("WANConnectionDevice", 1);
    public static final ServiceType IP_SERVICE_TYPE = new UDAServiceType("WANIPConnection", 1);
    public static final ServiceType PPP_SERVICE_TYPE = new UDAServiceType("WANPPPConnection", 1);
    protected PortMapping[] portMappings;
    protected Map<Service, List<PortMapping>> activePortMappings = new HashMap<Service, List<PortMapping>>();

    public PortMappingListener(PortMapping portMapping) {
        this(new PortMapping[]{portMapping});
    }

    public PortMappingListener(PortMapping[] portMappings) {
        this.portMappings = portMappings;
    }

    @Override
    public synchronized void deviceAdded(Registry registry, Device device) {
        Service connectionService = this.discoverConnectionService(device);
        if (connectionService == null) {
            return;
        }
        log.fine("Activating port mappings on: " + connectionService);
        final ArrayList activeForService = new ArrayList();
        for (final PortMapping pm : this.portMappings) {
            new PortMappingAdd(connectionService, registry.getUpnpService().getControlPoint(), pm){

                @Override
                public void success(ActionInvocation invocation) {
                    log.fine("Port mapping added: " + pm);
                    activeForService.add(pm);
                }

                @Override
                public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                    PortMappingListener.this.handleFailureMessage("Failed to add port mapping: " + pm);
                    PortMappingListener.this.handleFailureMessage("Reason: " + defaultMsg);
                }
            }.run();
        }
        this.activePortMappings.put(connectionService, activeForService);
    }

    @Override
    public synchronized void deviceRemoved(Registry registry, Device device) {
        for (Service service : device.findServices()) {
            Iterator<Map.Entry<Service, List<PortMapping>>> it = this.activePortMappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Service, List<PortMapping>> activeEntry = it.next();
                if (!activeEntry.getKey().equals(service)) continue;
                if (activeEntry.getValue().size() > 0) {
                    this.handleFailureMessage("Device disappeared, couldn't delete port mappings: " + activeEntry.getValue().size());
                }
                it.remove();
            }
        }
    }

    @Override
    public synchronized void beforeShutdown(Registry registry) {
        for (Map.Entry<Service, List<PortMapping>> activeEntry : this.activePortMappings.entrySet()) {
            final Iterator<PortMapping> it = activeEntry.getValue().iterator();
            while (it.hasNext()) {
                final PortMapping pm = it.next();
                log.fine("Trying to delete port mapping on IGD: " + pm);
                new PortMappingDelete(activeEntry.getKey(), registry.getUpnpService().getControlPoint(), pm){

                    @Override
                    public void success(ActionInvocation invocation) {
                        log.fine("Port mapping deleted: " + pm);
                        it.remove();
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        PortMappingListener.this.handleFailureMessage("Failed to delete port mapping: " + pm);
                        PortMappingListener.this.handleFailureMessage("Reason: " + defaultMsg);
                    }
                }.run();
            }
        }
    }

    protected Service discoverConnectionService(Device device) {
        if (!device.getType().equals(IGD_DEVICE_TYPE)) {
            return null;
        }
        Device[] connectionDevices = device.findDevices(CONNECTION_DEVICE_TYPE);
        if (connectionDevices.length == 0) {
            log.fine("IGD doesn't support '" + CONNECTION_DEVICE_TYPE + "': " + device);
            return null;
        }
        Device connectionDevice = connectionDevices[0];
        log.fine("Using first discovered WAN connection device: " + connectionDevice);
        Object ipConnectionService = connectionDevice.findService(IP_SERVICE_TYPE);
        Object pppConnectionService = connectionDevice.findService(PPP_SERVICE_TYPE);
        if (ipConnectionService == null && pppConnectionService == null) {
            log.fine("IGD doesn't support IP or PPP WAN connection service: " + device);
        }
        return ipConnectionService != null ? ipConnectionService : pppConnectionService;
    }

    protected void handleFailureMessage(String s) {
        log.warning(s);
    }
}

