/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.lastchange;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.support.lastchange.Event;
import org.fourthline.cling.support.lastchange.EventedValue;
import org.fourthline.cling.support.lastchange.InstanceID;
import org.fourthline.cling.support.lastchange.LastChangeParser;

public class LastChange {
    private final Event event;
    private final LastChangeParser parser;
    private String previousValue;

    public LastChange(String s) {
        throw new UnsupportedOperationException("This constructor is only for service binding detection");
    }

    public LastChange(LastChangeParser parser, Event event) {
        this.parser = parser;
        this.event = event;
    }

    public LastChange(LastChangeParser parser) {
        this(parser, new Event());
    }

    public LastChange(LastChangeParser parser, String xml) throws Exception {
        this.event = xml != null && xml.length() > 0 ? parser.parse(xml) : new Event();
        this.parser = parser;
    }

    public synchronized void reset() {
        this.previousValue = this.toString();
        this.event.clear();
    }

    public synchronized void setEventedValue(int instanceID, EventedValue ... ev) {
        this.setEventedValue(new UnsignedIntegerFourBytes(instanceID), ev);
    }

    public synchronized void setEventedValue(UnsignedIntegerFourBytes instanceID, EventedValue ... ev) {
        for (EventedValue eventedValue : ev) {
            if (eventedValue == null) continue;
            this.event.setEventedValue(instanceID, eventedValue);
        }
    }

    public synchronized UnsignedIntegerFourBytes[] getInstanceIDs() {
        ArrayList<UnsignedIntegerFourBytes> list = new ArrayList<UnsignedIntegerFourBytes>();
        for (InstanceID instanceID : this.event.getInstanceIDs()) {
            list.add(instanceID.getId());
        }
        return list.toArray(new UnsignedIntegerFourBytes[list.size()]);
    }

    synchronized EventedValue[] getEventedValues(UnsignedIntegerFourBytes instanceID) {
        InstanceID inst = this.event.getInstanceID(instanceID);
        return inst != null ? inst.getValues().toArray(new EventedValue[inst.getValues().size()]) : null;
    }

    public synchronized <EV extends EventedValue> EV getEventedValue(int instanceID, Class<EV> type) {
        return this.getEventedValue(new UnsignedIntegerFourBytes(instanceID), type);
    }

    public synchronized <EV extends EventedValue> EV getEventedValue(UnsignedIntegerFourBytes id, Class<EV> type) {
        return this.event.getEventedValue(id, type);
    }

    public synchronized void fire(PropertyChangeSupport propertyChangeSupport) {
        String lastChanges = this.toString();
        if (lastChanges != null && lastChanges.length() > 0) {
            propertyChangeSupport.firePropertyChange("LastChange", this.previousValue, lastChanges);
            this.reset();
        }
    }

    public synchronized String toString() {
        if (!this.event.hasChanges()) {
            return "";
        }
        try {
            return this.parser.generate(this.event);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

