/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.texboobcat.tunnelyP2p.util.Log;

public class TunnelConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TunnelConfig instance;
    private static final String CONFIG_FILE = "config/tunnely-p2p.json";
    public int defaultBindPort = 25566;
    public int defaultProxyPort = 25999;
    public int defaultMinecraftPort = 25565;
    public int maxPeers = 4;
    public long defaultTTL = 3600L;
    public boolean enableUPnP = true;
    public boolean enableUdpHolePunch = true;
    public boolean enableTcpHolePunch = true;
    public int connectionTimeout = 5000;
    public int keepaliveInterval = 10000;
    public long uploadBytesPerSec = 0L;
    public long downloadBytesPerSec = 0L;
    public boolean requireAuthentication = true;
    public boolean allowExpiredTokens = false;
    public boolean showTokenInChat = true;
    public boolean includeLocalIPInToken = true;
    public String locale = "en_us";
    public boolean enableAdvancedMetrics = true;
    public boolean showNotifications = true;
    public int udpBufferSize = 8192;
    public int tcpBufferSize = 8192;
    public int maxRetries = 10;
    public boolean enableLogging = true;
    public String logLevel = "INFO";
    public boolean debug = false;

    private TunnelConfig() {
    }

    public static synchronized TunnelConfig getInstance() {
        if (instance == null) {
            instance = TunnelConfig.load();
        }
        return instance;
    }

    private static TunnelConfig load() {
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (Files.exists(configPath, new LinkOption[0])) {
            TunnelConfig tunnelConfig;
            block9: {
                BufferedReader reader = Files.newBufferedReader(configPath);
                try {
                    TunnelConfig config = GSON.fromJson((Reader)reader, TunnelConfig.class);
                    Log.d("[Config] Loaded configuration from config/tunnely-p2p.json");
                    tunnelConfig = config;
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Log.e("[Config] Failed to load configuration: " + e.getMessage());
                    }
                }
                ((Reader)reader).close();
            }
            return tunnelConfig;
        }
        TunnelConfig config = new TunnelConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Path configPath = Paths.get(CONFIG_FILE, new String[0]);
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
                Log.d("[Config] Saved configuration to config/tunnely-p2p.json");
            }
        }
        catch (IOException e) {
            Log.e("[Config] Failed to save configuration: " + e.getMessage());
        }
    }

    public void resetToDefaults() {
        TunnelConfig defaults = new TunnelConfig();
        this.copyFrom(defaults);
        this.save();
    }

    private void copyFrom(TunnelConfig other) {
        this.defaultBindPort = other.defaultBindPort;
        this.defaultProxyPort = other.defaultProxyPort;
        this.defaultMinecraftPort = other.defaultMinecraftPort;
        this.maxPeers = other.maxPeers;
        this.defaultTTL = other.defaultTTL;
        this.enableUPnP = other.enableUPnP;
        this.enableUdpHolePunch = other.enableUdpHolePunch;
        this.enableTcpHolePunch = other.enableTcpHolePunch;
        this.connectionTimeout = other.connectionTimeout;
        this.keepaliveInterval = other.keepaliveInterval;
        this.uploadBytesPerSec = other.uploadBytesPerSec;
        this.downloadBytesPerSec = other.downloadBytesPerSec;
        this.requireAuthentication = other.requireAuthentication;
        this.allowExpiredTokens = other.allowExpiredTokens;
        this.showTokenInChat = other.showTokenInChat;
        this.includeLocalIPInToken = other.includeLocalIPInToken;
        this.locale = other.locale;
        this.enableAdvancedMetrics = other.enableAdvancedMetrics;
        this.showNotifications = other.showNotifications;
        this.udpBufferSize = other.udpBufferSize;
        this.tcpBufferSize = other.tcpBufferSize;
        this.maxRetries = other.maxRetries;
        this.enableLogging = other.enableLogging;
        this.logLevel = other.logLevel;
        this.debug = other.debug;
    }
}

