/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.connection;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.texboobcat.tunnelyP2p.nat.TcpHolePuncher;
import org.texboobcat.tunnelyP2p.token.ConnectionToken;
import org.texboobcat.tunnelyP2p.udp.UdpHolePuncher;
import org.texboobcat.tunnelyP2p.util.Log;

public class ConnectionStrategy {
    public static ConnectionResult connect(ConnectionToken token, int localUdpPort) {
        Object socket;
        ArrayList<Object> attemptLog = new ArrayList<Object>();
        ConnectionToken.NATInfo natInfo = token.getNatInfo();
        if (natInfo.hasPublicEndpoint()) {
            attemptLog.add("Trying direct TCP to " + natInfo.getPublicIP() + ":" + natInfo.getPublicPort());
            socket = ConnectionStrategy.tryDirectTcp(natInfo.getPublicIP(), natInfo.getPublicPort());
            if (socket != null) {
                Log.d("[Connection] Success via direct TCP to public IP");
                return ConnectionResult.success(Strategy.DIRECT_TCP_PUBLIC, (Socket)socket);
            }
            attemptLog.add("  Failed: connection refused or timeout");
        }
        if (natInfo.hasLocalEndpoint()) {
            attemptLog.add("Trying direct TCP to local " + natInfo.getLocalIP() + ":" + natInfo.getLocalPort());
            socket = ConnectionStrategy.tryDirectTcp(natInfo.getLocalIP(), natInfo.getLocalPort());
            if (socket != null) {
                Log.d("[Connection] Success via direct TCP to local IP (LAN)");
                return ConnectionResult.success(Strategy.DIRECT_TCP_LOCAL, (Socket)socket);
            }
            attemptLog.add("  Failed: not on same local network");
        }
        if (natInfo.hasPublicEndpoint() && !natInfo.getUdpPorts().isEmpty()) {
            socket = natInfo.getUdpPorts().iterator();
            while (socket.hasNext()) {
                int udpPort = (Integer)socket.next();
                attemptLog.add("Trying UDP hole punch to " + natInfo.getPublicIP() + ":" + udpPort);
                DatagramSocket udpSocket = ConnectionStrategy.tryUdpHolePunch(localUdpPort, natInfo.getPublicIP(), udpPort);
                if (udpSocket != null) {
                    Log.d("[Connection] Success via UDP hole punching");
                    return ConnectionResult.successUdp(Strategy.UDP_HOLE_PUNCH, udpSocket);
                }
                attemptLog.add("  Failed: NAT type incompatible");
            }
        }
        if (natInfo.hasPublicEndpoint()) {
            attemptLog.add("Trying TCP hole punch to " + natInfo.getPublicIP() + ":" + natInfo.getPublicPort());
            socket = ConnectionStrategy.tryTcpHolePunch(natInfo.getPublicPort(), natInfo.getPublicIP(), natInfo.getPublicPort());
            if (socket != null) {
                Log.d("[Connection] Success via TCP hole punching");
                return ConnectionResult.success(Strategy.TCP_HOLE_PUNCH, (Socket)socket);
            }
            attemptLog.add("  Failed: NAT type incompatible");
        }
        String errorMsg = "All connection strategies failed:\n" + String.join((CharSequence)"\n", attemptLog);
        Log.e(errorMsg);
        return ConnectionResult.failure(errorMsg);
    }

    private static Socket tryDirectTcp(String host, int port) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), 5000);
            return socket;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static DatagramSocket tryUdpHolePunch(int localPort, String remoteIP, int remotePort) {
        try {
            UdpHolePuncher puncher = new UdpHolePuncher(localPort);
            return puncher.punchHole(remoteIP, remotePort);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Socket tryTcpHolePunch(int localPort, String remoteIP, int remotePort) {
        return TcpHolePuncher.punchHole(localPort, remoteIP, remotePort);
    }

    public static enum Strategy {
        DIRECT_TCP_PUBLIC("Direct TCP to public IP/port"),
        DIRECT_TCP_LOCAL("Direct TCP to local IP/port (LAN)"),
        UDP_HOLE_PUNCH("UDP hole punching"),
        TCP_HOLE_PUNCH("TCP hole punching"),
        FALLBACK("Manual configuration required");

        private final String description;

        private Strategy(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class ConnectionResult {
        public final boolean success;
        public final Strategy strategy;
        public final Socket tcpSocket;
        public final DatagramSocket udpSocket;
        public final String error;

        private ConnectionResult(boolean success, Strategy strategy, Socket tcpSocket, DatagramSocket udpSocket, String error) {
            this.success = success;
            this.strategy = strategy;
            this.tcpSocket = tcpSocket;
            this.udpSocket = udpSocket;
            this.error = error;
        }

        public static ConnectionResult success(Strategy strategy, Socket tcpSocket) {
            return new ConnectionResult(true, strategy, tcpSocket, null, null);
        }

        public static ConnectionResult successUdp(Strategy strategy, DatagramSocket udpSocket) {
            return new ConnectionResult(true, strategy, null, udpSocket, null);
        }

        public static ConnectionResult failure(String error) {
            return new ConnectionResult(false, Strategy.FALLBACK, null, null, error);
        }

        public boolean isTcp() {
            return this.tcpSocket != null;
        }

        public boolean isUdp() {
            return this.udpSocket != null;
        }
    }
}

