/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.texboobcat.tunnelyP2p.crypto.CryptoManager;
import org.texboobcat.tunnelyP2p.crypto.SessionKeys;
import org.texboobcat.tunnelyP2p.protocol.KeepaliveMessage;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;
import org.texboobcat.tunnelyP2p.protocol.StreamDataMessage;

public class PeerConnection
implements AutoCloseable {
    private final Socket socket;
    private final DataInputStream input;
    private final DataOutputStream output;
    private final SessionKeys sessionKeys;
    private final UUID sessionId;
    private final UUID peerUUID;
    private final String peerName;
    private final AtomicInteger sequenceCounter = new AtomicInteger(0);
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ExecutorService messageExecutor = Executors.newSingleThreadExecutor();
    private final AtomicLong nonceCounter = new AtomicLong(0L);
    private Consumer<ProtocolMessage> messageHandler;
    private Consumer<Exception> errorHandler;
    private volatile long lastActivityTime = System.currentTimeMillis();
    private volatile long bytesSent = 0L;
    private volatile long bytesReceived = 0L;

    public PeerConnection(Socket socket, SessionKeys sessionKeys, UUID sessionId, UUID peerUUID, String peerName) throws IOException {
        this.socket = socket;
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.sessionKeys = sessionKeys;
        this.sessionId = sessionId;
        this.peerUUID = peerUUID;
        this.peerName = peerName;
        this.executor.submit(this::receiveLoop);
        this.scheduler.scheduleAtFixedRate(this::sendKeepalive, 10L, 10L, TimeUnit.SECONDS);
    }

    public void setMessageHandler(Consumer<ProtocolMessage> handler) {
        this.messageHandler = handler;
    }

    public void setErrorHandler(Consumer<Exception> handler) {
        this.errorHandler = handler;
    }

    public void sendStreamData(int connectionId, byte[] data) throws IOException, GeneralSecurityException {
        byte[] nonce = this.generateMonotonicNonce();
        byte[] encrypted = CryptoManager.encryptChaCha20Poly1305(this.sessionKeys.getRawEncryptionKey(), nonce, data, null);
        int seqNum = this.sequenceCounter.getAndIncrement();
        StreamDataMessage msg = new StreamDataMessage(connectionId, seqNum, encrypted, nonce);
        this.sendMessage(msg);
    }

    private byte[] generateMonotonicNonce() {
        byte[] nonce = new byte[12];
        long counter = this.nonceCounter.getAndIncrement();
        for (int i = 0; i < 8; ++i) {
            nonce[7 - i] = (byte)(counter >> i * 8);
        }
        byte[] sessionIdBytes = this.sessionId.toString().getBytes();
        int hash = Arrays.hashCode(sessionIdBytes);
        nonce[8] = (byte)(hash >> 24);
        nonce[9] = (byte)(hash >> 16);
        nonce[10] = (byte)(hash >> 8);
        nonce[11] = (byte)hash;
        return nonce;
    }

    public synchronized void sendMessage(ProtocolMessage message) throws IOException {
        byte[] serialized = message.serialize();
        this.output.writeInt(serialized.length);
        this.output.write(serialized);
        this.output.flush();
        this.bytesSent += (long)(serialized.length + 4);
        this.lastActivityTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveLoop() {
        try {
            while (this.running.get() && !this.socket.isClosed()) {
                int length = this.input.readInt();
                if (length <= 0 || length > 1000000) {
                    throw new IOException("Invalid message length: " + length);
                }
                byte[] data = new byte[length];
                this.input.readFully(data);
                this.bytesReceived += (long)(length + 4);
                this.lastActivityTime = System.currentTimeMillis();
                ProtocolMessage message = ProtocolMessage.deserialize(data);
                if (this.messageHandler == null) continue;
                this.messageExecutor.submit(() -> this.messageHandler.accept(message));
            }
        }
        catch (Exception e) {
            if (this.running.get() && this.errorHandler != null) {
                this.errorHandler.accept(e);
            }
        }
        finally {
            this.close();
        }
    }

    private void sendKeepalive() {
        block3: {
            try {
                if (this.running.get() && !this.socket.isClosed()) {
                    this.sendMessage(new KeepaliveMessage(System.currentTimeMillis()));
                }
            }
            catch (IOException e) {
                if (this.errorHandler == null) break block3;
                this.errorHandler.accept(e);
            }
        }
    }

    public boolean isAlive() {
        long timeSinceActivity = System.currentTimeMillis() - this.lastActivityTime;
        return timeSinceActivity < 30000L;
    }

    public UUID getPeerUUID() {
        return this.peerUUID;
    }

    public String getPeerName() {
        return this.peerName;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getLatency() {
        return System.currentTimeMillis() - this.lastActivityTime;
    }

    public SessionKeys getSessionKeys() {
        return this.sessionKeys;
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.scheduler.shutdown();
                this.executor.shutdown();
                this.messageExecutor.shutdown();
                this.socket.close();
                this.sessionKeys.clear();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

