/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.metrics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionMetrics {
    private final AtomicLong totalBytesSent = new AtomicLong(0L);
    private final AtomicLong totalBytesReceived = new AtomicLong(0L);
    private final AtomicLong totalPacketsSent = new AtomicLong(0L);
    private final AtomicLong totalPacketsReceived = new AtomicLong(0L);
    private final AtomicLong packetsDropped = new AtomicLong(0L);
    private final AtomicLong encryptionErrors = new AtomicLong(0L);
    private final AtomicLong decryptionErrors = new AtomicLong(0L);
    private final AtomicLong retransmissions = new AtomicLong(0L);
    private volatile double smoothedRTT = 0.0;
    private volatile long minRTT = Long.MAX_VALUE;
    private volatile long maxRTT = 0L;
    private volatile long lastRTT = 0L;
    private volatile double jitter = 0.0;
    private final long connectionStartTime = System.currentTimeMillis();
    private volatile long lastActivityTime = System.currentTimeMillis();
    private final AtomicInteger reconnectCount = new AtomicInteger(0);

    public void recordSent(long bytes, int packets) {
        this.totalBytesSent.addAndGet(bytes);
        this.totalPacketsSent.addAndGet(packets);
        this.lastActivityTime = System.currentTimeMillis();
    }

    public void recordReceived(long bytes, int packets) {
        this.totalBytesReceived.addAndGet(bytes);
        this.totalPacketsReceived.addAndGet(packets);
        this.lastActivityTime = System.currentTimeMillis();
    }

    public void recordRTT(long rttMs) {
        this.lastRTT = rttMs;
        if (rttMs < this.minRTT) {
            this.minRTT = rttMs;
        }
        if (rttMs > this.maxRTT) {
            this.maxRTT = rttMs;
        }
        if (this.smoothedRTT == 0.0) {
            this.smoothedRTT = rttMs;
        } else {
            double alpha = 0.125;
            this.smoothedRTT = (1.0 - alpha) * this.smoothedRTT + alpha * (double)rttMs;
        }
        double delta = Math.abs((double)rttMs - this.smoothedRTT);
        this.jitter = 0.75 * this.jitter + 0.25 * delta;
    }

    public void recordPacketDrop() {
        this.packetsDropped.incrementAndGet();
    }

    public void recordEncryptionError() {
        this.encryptionErrors.incrementAndGet();
    }

    public void recordDecryptionError() {
        this.decryptionErrors.incrementAndGet();
    }

    public void recordRetransmission() {
        this.retransmissions.incrementAndGet();
    }

    public void recordReconnect() {
        this.reconnectCount.incrementAndGet();
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent.get();
    }

    public long getTotalBytesReceived() {
        return this.totalBytesReceived.get();
    }

    public long getTotalPacketsSent() {
        return this.totalPacketsSent.get();
    }

    public long getTotalPacketsReceived() {
        return this.totalPacketsReceived.get();
    }

    public long getPacketsDropped() {
        return this.packetsDropped.get();
    }

    public long getEncryptionErrors() {
        return this.encryptionErrors.get();
    }

    public long getDecryptionErrors() {
        return this.decryptionErrors.get();
    }

    public long getRetransmissions() {
        return this.retransmissions.get();
    }

    public double getSmoothedRTT() {
        return this.smoothedRTT;
    }

    public long getMinRTT() {
        return this.minRTT == Long.MAX_VALUE ? 0L : this.minRTT;
    }

    public long getMaxRTT() {
        return this.maxRTT;
    }

    public long getLastRTT() {
        return this.lastRTT;
    }

    public double getJitter() {
        return this.jitter;
    }

    public long getConnectionDuration() {
        return System.currentTimeMillis() - this.connectionStartTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public int getReconnectCount() {
        return this.reconnectCount.get();
    }

    public double getPacketLossRate() {
        long sent = this.totalPacketsSent.get();
        long dropped = this.packetsDropped.get();
        return sent > 0L ? (double)dropped / (double)(sent + dropped) : 0.0;
    }

    public double getAverageThroughput() {
        long duration = this.getConnectionDuration() / 1000L;
        if (duration == 0L) {
            return 0.0;
        }
        return (double)(this.totalBytesSent.get() + this.totalBytesReceived.get()) / (double)duration;
    }

    public int getConnectionQuality() {
        double lossRate = this.getPacketLossRate();
        double rtt = this.smoothedRTT;
        int score = 100;
        score -= (int)(lossRate * 50.0);
        if (rtt > 300.0) {
            score -= 30;
        } else if (rtt > 150.0) {
            score -= 20;
        } else if (rtt > 80.0) {
            score -= 10;
        }
        if (this.jitter > 50.0) {
            score -= 10;
        }
        return Math.max(0, Math.min(100, score));
    }

    public MetricsSummary getSummary() {
        return new MetricsSummary(this.totalBytesSent.get(), this.totalBytesReceived.get(), this.totalPacketsSent.get(), this.totalPacketsReceived.get(), this.packetsDropped.get(), this.smoothedRTT, this.getMinRTT(), this.getMaxRTT(), this.jitter, this.getPacketLossRate(), this.getAverageThroughput(), this.getConnectionQuality(), this.getConnectionDuration(), this.reconnectCount.get());
    }

    public static class MetricsSummary {
        public final long bytesSent;
        public final long bytesReceived;
        public final long packetsSent;
        public final long packetsReceived;
        public final long packetsDropped;
        public final double avgRTT;
        public final long minRTT;
        public final long maxRTT;
        public final double jitter;
        public final double packetLossRate;
        public final double avgThroughput;
        public final int connectionQuality;
        public final long connectionDuration;
        public final int reconnects;

        public MetricsSummary(long bytesSent, long bytesReceived, long packetsSent, long packetsReceived, long packetsDropped, double avgRTT, long minRTT, long maxRTT, double jitter, double packetLossRate, double avgThroughput, int connectionQuality, long connectionDuration, int reconnects) {
            this.bytesSent = bytesSent;
            this.bytesReceived = bytesReceived;
            this.packetsSent = packetsSent;
            this.packetsReceived = packetsReceived;
            this.packetsDropped = packetsDropped;
            this.avgRTT = avgRTT;
            this.minRTT = minRTT;
            this.maxRTT = maxRTT;
            this.jitter = jitter;
            this.packetLossRate = packetLossRate;
            this.avgThroughput = avgThroughput;
            this.connectionQuality = connectionQuality;
            this.connectionDuration = connectionDuration;
            this.reconnects = reconnects;
        }

        public String toString() {
            return String.format("Metrics[sent=%d, recv=%d, rtt=%.1fms, loss=%.2f%%, quality=%d/100]", this.bytesSent, this.bytesReceived, this.avgRTT, this.packetLossRate * 100.0, this.connectionQuality);
        }
    }
}

