/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.nat;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.texboobcat.tunnelyP2p.nat.NATTraversal;

public final class StunClient {
    private static final Logger LOG = Logger.getLogger(StunClient.class.getName());
    private static final int STUN_BINDING_REQUEST = 1;
    private static final int STUN_BINDING_SUCCESS = 257;
    private static final int ATTR_XOR_MAPPED_ADDRESS = 32;
    private static final int ATTR_MAPPED_ADDRESS = 1;
    private static final int ATTR_RESPONSE_ORIGIN = 32811;
    private static final int ATTR_OTHER_ADDRESS = 32812;
    private static final int MAGIC_COOKIE = 554869826;
    private static final int DEFAULT_TIMEOUT_MS = 2000;
    private static final int DEFAULT_RETRIES = 2;
    private static final int PARALLEL_QUERY_TIMEOUT_MS = 5000;

    private StunClient() {
    }

    public static Mapping query(DatagramSocket socket, String serverHost, int serverPort, int timeoutMs) {
        return StunClient.queryWithRetry(socket, serverHost, serverPort, timeoutMs, 1);
    }

    public static Mapping queryWithRetry(DatagramSocket socket, String serverHost, int serverPort, int timeoutMs, int retries) {
        for (int attempt = 0; attempt < retries; ++attempt) {
            try {
                socket.setSoTimeout(timeoutMs);
                byte[] txId = new byte[12];
                new SecureRandom().nextBytes(txId);
                ByteBuffer req = ByteBuffer.allocate(20);
                req.putShort((short)1);
                req.putShort((short)0);
                req.putInt(554869826);
                req.put(txId);
                byte[] data = req.array();
                DatagramPacket out = new DatagramPacket(data, data.length, InetAddress.getByName(serverHost), serverPort);
                socket.send(out);
                byte[] buf = new byte[1500];
                DatagramPacket in = new DatagramPacket(buf, buf.length);
                socket.receive(in);
                Mapping result = StunClient.parseResponse(buf, in.getLength(), txId);
                if (result == null) continue;
                return new Mapping(result.publicIP, result.publicPort, serverHost + ":" + serverPort);
            }
            catch (SocketTimeoutException e) {
                if (attempt != retries - 1) continue;
                LOG.fine("STUN query to " + serverHost + " timed out after " + retries + " attempts");
                continue;
            }
            catch (Exception e) {
                LOG.fine("STUN query failed: " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    private static Mapping parseResponse(byte[] buf, int len, byte[] expectedTxId) {
        if (len < 20) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(buf, 0, len);
        int type = bb.getShort() & 0xFFFF;
        int msgLen = bb.getShort() & 0xFFFF;
        int cookie = bb.getInt();
        if (expectedTxId != null) {
            for (int i = 0; i < 12; ++i) {
                if (buf[8 + i] == expectedTxId[i]) continue;
                return null;
            }
        }
        if (type != 257) {
            return null;
        }
        int offset = 20;
        while (offset + 4 <= len) {
            int at = (buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF;
            int aval = offset + 4;
            int alen = (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            if (aval + alen > len) break;
            if (at == 32) {
                if (alen >= 8) {
                    family = buf[aval + 1] & 0xFF;
                    int xport = ((buf[aval + 2] & 0xFF) << 8 | buf[aval + 3] & 0xFF) ^ 0x2112;
                    if (family == 1 && alen >= 8) {
                        int addr0 = (buf[aval + 4] ^ 0x21) & 0xFF;
                        int addr1 = (buf[aval + 5] ^ 0x12) & 0xFF;
                        int addr2 = (buf[aval + 6] ^ 0xFFFFFFA4) & 0xFF;
                        int addr3 = (buf[aval + 7] ^ 0x42) & 0xFF;
                        String ip = addr0 + "." + addr1 + "." + addr2 + "." + addr3;
                        return new Mapping(ip, xport & 0xFFFF);
                    }
                }
            } else if (at == 1 && alen >= 8) {
                family = buf[aval + 1] & 0xFF;
                int port = (buf[aval + 2] & 0xFF) << 8 | buf[aval + 3] & 0xFF;
                if (family == 1) {
                    int a = buf[aval + 4] & 0xFF;
                    int b = buf[aval + 5] & 0xFF;
                    int c = buf[aval + 6] & 0xFF;
                    int d = buf[aval + 7] & 0xFF;
                    String ip = a + "." + b + "." + c + "." + d;
                    return new Mapping(ip, port & 0xFFFF);
                }
            }
            int padded = alen + 3 & 0xFFFFFFFC;
            offset = aval + padded;
        }
        return null;
    }

    public static NATTraversal.NATType detectNatType() {
        try {
            NatDiagnosis d = StunClient.diagnose();
            return d.type;
        }
        catch (Exception e) {
            LOG.warning("NAT detection failed: " + e.getMessage());
            return NATTraversal.NATType.UNKNOWN;
        }
    }

    public static String getPublicIP() {
        DatagramSocket sock = new DatagramSocket();
        try {
            Mapping m = StunClient.queryWithRetry(sock, "stun.l.google.com", 19302, 2000, 2);
            String string = m != null ? m.publicIP : null;
            sock.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.fine("Failed to get public IP: " + e.getMessage());
                return null;
            }
        }
    }

    public static String getPublicIP(String stunServer, int stunPort) {
        DatagramSocket sock = new DatagramSocket();
        try {
            Mapping m = StunClient.queryWithRetry(sock, stunServer, stunPort, 2000, 2);
            String string = m != null ? m.publicIP : null;
            sock.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.fine("Failed to get public IP from " + stunServer + ": " + e.getMessage());
                return null;
            }
        }
    }

    public static NatDiagnosis diagnose() {
        return StunClient.diagnoseInternal(false);
    }

    public static NatDiagnosis diagnoseParallel() {
        return StunClient.diagnoseInternal(true);
    }

    private static NatDiagnosis diagnoseInternal(boolean parallel) {
        Mapping use;
        int totalProbes;
        int successfulProbes;
        int localPortUsed;
        boolean portPreserving;
        boolean varies;
        Mapping primary;
        ArrayList<Mapping> allMappings;
        String[][] servers;
        String localIP;
        block29: {
            localIP = NATTraversal.getLocalIP();
            servers = new String[][]{{"stun.l.google.com", "19302"}, {"stun1.l.google.com", "19302"}, {"stun2.l.google.com", "19302"}, {"stun3.l.google.com", "19302"}, {"stun.cloudflare.com", "3478"}};
            allMappings = new ArrayList<Mapping>();
            primary = null;
            varies = false;
            portPreserving = false;
            localPortUsed = -1;
            successfulProbes = 0;
            totalProbes = servers.length;
            try (DatagramSocket s1 = new DatagramSocket();){
                localPortUsed = s1.getLocalPort();
                if (parallel) {
                    ExecutorService executor = Executors.newFixedThreadPool(servers.length);
                    ArrayList<Future<Mapping>> futures = new ArrayList<Future<Mapping>>();
                    for (String[] srv : servers) {
                        futures.add(executor.submit(() -> StunClient.queryWithRetry(s1, srv[0], Integer.parseInt(srv[1]), 2000, 2)));
                    }
                    executor.shutdown();
                    try {
                        executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    for (Future future : futures) {
                        try {
                            Mapping m = (Mapping)future.get(100L, TimeUnit.MILLISECONDS);
                            if (m == null) continue;
                            ++successfulProbes;
                            allMappings.add(m);
                            if (primary == null) {
                                primary = m;
                                continue;
                            }
                            if (primary.equals(m)) continue;
                            varies = true;
                        }
                        catch (Exception m) {}
                    }
                    break block29;
                }
                for (String[] stringArray : servers) {
                    Mapping m = StunClient.queryWithRetry(s1, stringArray[0], Integer.parseInt(stringArray[1]), 2000, 2);
                    if (m == null) continue;
                    ++successfulProbes;
                    allMappings.add(m);
                    if (primary == null) {
                        primary = m;
                        continue;
                    }
                    if (primary.equals(m)) continue;
                    varies = true;
                }
            }
            catch (Exception e) {
                LOG.warning("Socket error during diagnosis: " + e.getMessage());
            }
        }
        Mapping second = null;
        int attempts2 = 0;
        try (DatagramSocket s2 = new DatagramSocket();){
            for (String[] srv : servers) {
                ++attempts2;
                second = StunClient.queryWithRetry(s2, srv[0], Integer.parseInt(srv[1]), 2000, 2);
                if (second == null) continue;
                ++successfulProbes;
                break;
            }
        }
        catch (Exception e) {
            LOG.fine("Second socket test failed: " + e.getMessage());
        }
        totalProbes += attempts2;
        if (primary == null && second == null) {
            return new NatDiagnosis(NATTraversal.NATType.UNKNOWN, null, false, false, "No STUN response from any server", allMappings, successfulProbes, totalProbes);
        }
        Mapping mapping = use = primary != null ? primary : second;
        if (use.publicIP != null && use.publicIP.equals(localIP)) {
            return new NatDiagnosis(NATTraversal.NATType.NONE, use, false, true, "Public IP equals local IP - no NAT detected", allMappings, successfulProbes, totalProbes);
        }
        if (varies) {
            return new NatDiagnosis(NATTraversal.NATType.SYMMETRIC, use, true, false, "Mapping varies by destination - symmetric NAT", allMappings, successfulProbes, totalProbes);
        }
        if (use != null && localPortUsed > 0) {
            portPreserving = use.publicPort == localPortUsed;
        }
        NATTraversal.NATType approx = NATTraversal.NATType.RESTRICTED_CONE;
        String string = portPreserving ? "Port-preserving mapping detected - likely cone NAT" : "Stable mapping across servers - cone-like NAT";
        return new NatDiagnosis(approx, use, false, portPreserving, string, allMappings, successfulProbes, totalProbes);
    }

    public static boolean isStunReachable() {
        return StunClient.getPublicIP() != null;
    }

    public static boolean isBehindNat() {
        String publicIP = StunClient.getPublicIP();
        String localIP = NATTraversal.getLocalIP();
        return publicIP != null && localIP != null && !publicIP.equals(localIP);
    }

    public static class Mapping {
        public final String publicIP;
        public final int publicPort;
        public final String responseOrigin;

        public Mapping(String ip, int port) {
            this(ip, port, null);
        }

        public Mapping(String ip, int port, String origin) {
            this.publicIP = ip;
            this.publicPort = port;
            this.responseOrigin = origin;
        }

        public String toString() {
            return this.publicIP + ":" + this.publicPort + (String)(this.responseOrigin != null ? " (via " + this.responseOrigin + ")" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping m = (Mapping)o;
            return this.publicPort == m.publicPort && this.publicIP != null && this.publicIP.equals(m.publicIP);
        }

        public int hashCode() {
            return this.publicIP.hashCode() * 31 + this.publicPort;
        }
    }

    public static class NatDiagnosis {
        public final NATTraversal.NATType type;
        public final Mapping mapping;
        public final boolean mappingVariesAcrossServers;
        public final boolean portPreserving;
        public final String reason;
        public final List<Mapping> allMappings;
        public final int successfulProbes;
        public final int totalProbes;

        public NatDiagnosis(NATTraversal.NATType type, Mapping mapping, boolean mappingVariesAcrossServers, boolean portPreserving, String reason) {
            this(type, mapping, mappingVariesAcrossServers, portPreserving, reason, null, 0, 0);
        }

        public NatDiagnosis(NATTraversal.NATType type, Mapping mapping, boolean mappingVariesAcrossServers, boolean portPreserving, String reason, List<Mapping> allMappings, int successful, int total) {
            this.type = type;
            this.mapping = mapping;
            this.mappingVariesAcrossServers = mappingVariesAcrossServers;
            this.portPreserving = portPreserving;
            this.reason = reason;
            this.allMappings = allMappings != null ? allMappings : new ArrayList();
            this.successfulProbes = successful;
            this.totalProbes = total;
        }

        public double getReliabilityScore() {
            return this.totalProbes > 0 ? (double)this.successfulProbes / (double)this.totalProbes : 0.0;
        }
    }
}

