/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class StreamAckMessage
extends ProtocolMessage {
    private final int connectionId;
    private final int sequenceNumber;

    public StreamAckMessage(int connectionId, int sequenceNumber) {
        super(ProtocolMessage.MessageType.STREAM_ACK);
        this.connectionId = connectionId;
        this.sequenceNumber = sequenceNumber;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        dos.writeInt(this.connectionId);
        dos.writeInt(this.sequenceNumber);
        return baos.toByteArray();
    }

    public static StreamAckMessage deserializeFrom(DataInputStream dis) throws IOException {
        int connId = dis.readInt();
        int seqNum = dis.readInt();
        return new StreamAckMessage(connId, seqNum);
    }
}

