/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class StreamCloseMessage
extends ProtocolMessage {
    private final int connectionId;
    private final String reason;

    public StreamCloseMessage(int connectionId, String reason) {
        super(ProtocolMessage.MessageType.STREAM_CLOSE);
        this.connectionId = connectionId;
        this.reason = reason;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        dos.writeInt(this.connectionId);
        dos.writeUTF(this.reason != null ? this.reason : "");
        return baos.toByteArray();
    }

    public static StreamCloseMessage deserializeFrom(DataInputStream dis) throws IOException {
        int connId = dis.readInt();
        String reason = dis.readUTF();
        return new StreamCloseMessage(connId, reason.isEmpty() ? null : reason);
    }
}

