/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.texboobcat.tunnelyP2p.protocol.ProtocolMessage;

public class StreamDataMessage
extends ProtocolMessage {
    private final int connectionId;
    private final int sequenceNumber;
    private final byte[] encryptedPayload;
    private final byte[] nonce;

    public StreamDataMessage(int connectionId, int sequenceNumber, byte[] encryptedPayload, byte[] nonce) {
        super(ProtocolMessage.MessageType.STREAM_DATA);
        this.connectionId = connectionId;
        this.sequenceNumber = sequenceNumber;
        this.encryptedPayload = encryptedPayload;
        this.nonce = nonce;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getEncryptedPayload() {
        return this.encryptedPayload;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(this.type.getId());
        dos.writeInt(this.connectionId);
        dos.writeInt(this.sequenceNumber);
        this.writeByteArray(dos, this.nonce);
        this.writeByteArray(dos, this.encryptedPayload);
        return baos.toByteArray();
    }

    public static StreamDataMessage deserializeFrom(DataInputStream dis) throws IOException {
        int connId = dis.readInt();
        int seqNum = dis.readInt();
        byte[] nonce = new StreamDataMessage(0, 0, null, null).readByteArray(dis);
        byte[] payload = new StreamDataMessage(0, 0, null, null).readByteArray(dis);
        return new StreamDataMessage(connId, seqNum, payload, nonce);
    }
}

