/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyP2p.qos;

import java.util.concurrent.atomic.AtomicLong;
import org.texboobcat.tunnelyP2p.qos.BandwidthLimiter;

public class QoSManager {
    private final BandwidthLimiter uploadLimiter;
    private final BandwidthLimiter downloadLimiter;
    private final AtomicLong totalBytesSent = new AtomicLong(0L);
    private final AtomicLong totalBytesReceived = new AtomicLong(0L);
    private final AtomicLong packetsDropped = new AtomicLong(0L);
    private volatile long currentLatency = 0L;
    private volatile long minLatency = Long.MAX_VALUE;
    private volatile long maxLatency = 0L;

    public QoSManager(long uploadBytesPerSec, long downloadBytesPerSec) {
        this.uploadLimiter = uploadBytesPerSec > 0L ? new BandwidthLimiter(uploadBytesPerSec) : null;
        this.downloadLimiter = downloadBytesPerSec > 0L ? new BandwidthLimiter(downloadBytesPerSec) : null;
    }

    public boolean canSend(long bytes, Priority priority) {
        if (this.uploadLimiter == null) {
            return true;
        }
        long adjustedBytes = bytes / (long)priority.getWeight();
        return this.uploadLimiter.tryConsume(adjustedBytes);
    }

    public void waitToSend(long bytes, Priority priority) throws InterruptedException {
        if (this.uploadLimiter != null) {
            long adjustedBytes = bytes / (long)priority.getWeight();
            this.uploadLimiter.consume(adjustedBytes);
        }
        this.totalBytesSent.addAndGet(bytes);
    }

    public void recordReceived(long bytes) {
        if (this.downloadLimiter != null) {
            // empty if block
        }
        this.totalBytesReceived.addAndGet(bytes);
    }

    public void updateLatency(long latencyMs) {
        this.currentLatency = latencyMs;
        if (latencyMs < this.minLatency) {
            this.minLatency = latencyMs;
        }
        if (latencyMs > this.maxLatency) {
            this.maxLatency = latencyMs;
        }
    }

    public void recordPacketDrop() {
        this.packetsDropped.incrementAndGet();
    }

    public double getUploadUtilization() {
        return this.uploadLimiter != null ? this.uploadLimiter.getUtilization() : 0.0;
    }

    public double getDownloadUtilization() {
        return this.downloadLimiter != null ? this.downloadLimiter.getUtilization() : 0.0;
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent.get();
    }

    public long getTotalBytesReceived() {
        return this.totalBytesReceived.get();
    }

    public long getCurrentLatency() {
        return this.currentLatency;
    }

    public long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    public long getMaxLatency() {
        return this.maxLatency;
    }

    public double getPacketLossRate() {
        long sent = this.totalBytesSent.get() / 1400L;
        long dropped = this.packetsDropped.get();
        return sent > 0L ? (double)dropped / (double)sent : 0.0;
    }

    public QoSStats getStats() {
        return new QoSStats(this.totalBytesSent.get(), this.totalBytesReceived.get(), this.currentLatency, this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency, this.maxLatency, this.packetsDropped.get(), this.getUploadUtilization(), this.getDownloadUtilization());
    }

    public static enum Priority {
        HIGH(3),
        NORMAL(2),
        LOW(1);

        private final int weight;

        private Priority(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static class QoSStats {
        public final long bytesSent;
        public final long bytesReceived;
        public final long latency;
        public final long minLatency;
        public final long maxLatency;
        public final long packetsDropped;
        public final double uploadUtilization;
        public final double downloadUtilization;

        public QoSStats(long bytesSent, long bytesReceived, long latency, long minLatency, long maxLatency, long packetsDropped, double uploadUtilization, double downloadUtilization) {
            this.bytesSent = bytesSent;
            this.bytesReceived = bytesReceived;
            this.latency = latency;
            this.minLatency = minLatency;
            this.maxLatency = maxLatency;
            this.packetsDropped = packetsDropped;
            this.uploadUtilization = uploadUtilization;
            this.downloadUtilization = downloadUtilization;
        }
    }
}

